﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <Windows.h>
#include <autoTestAssistTool/TmUtilityTypes.h>
#include <autoTestAssistTool/Common/autoTestAssistTool_LibTypes.h>

typedef TmUtilityResult (*GetConnectedTargetCount)(int* pOutCount);
typedef TmUtilityResult (*GetConnectedTargetSerialNumbers)(SerialNumberString* pOutSerialNumbers, int serialNumberCount);

class TmUtilityWrapper
{
public:
    TmUtilityWrapper()
    {
    }

    ~TmUtilityWrapper()
    {
        if (m_ModuleHandle != NULL)
        {
            ::FreeLibrary(m_ModuleHandle);
        }
    }

    bool TryLoadLibrary();
    bool TryLoadFunctions();

    GetConnectedTargetCount     m_GetConnectedTargetCountFunction;
    GetConnectedTargetSerialNumbers     m_GetConnectedTargetSerialNumbersFunction;

private:
    HMODULE m_ModuleHandle;
};
