﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <tchar.h>
#include "..\Common\testAutoTestAssistTool_Util.h"
#include "TmUtilityWrapper.h"

bool TmUtilityWrapper::TryLoadLibrary()
{
    auto libPath = autoTestAssistTool::util::GetSdkRootPath().append(
        "\\Tools\\AutoTestAssistTools\\Libraries\\TmUtility.dll");
    m_ModuleHandle = ::LoadLibraryA(libPath.c_str());
    return (m_ModuleHandle != NULL);
}

bool TmUtilityWrapper::TryLoadFunctions()
{
    if (m_ModuleHandle == NULL)
    {
        return false;
    }

    bool result = true;

    m_GetConnectedTargetCountFunction = (GetConnectedTargetCount)GetProcAddress(m_ModuleHandle, "GetConnectedTargetCount");
    if (m_GetConnectedTargetCountFunction == NULL)
    {
        printf("GetConnectedTargetCount is not found\n");
        result = false;
    }

    m_GetConnectedTargetSerialNumbersFunction = (GetConnectedTargetSerialNumbers)GetProcAddress(m_ModuleHandle, "GetConnectedTargetSerialNumbers");
    if (m_GetConnectedTargetSerialNumbersFunction == NULL)
    {
        printf("GetConnectedTargetSerialNumbers is not found\n");
        result = false;
    }

    return result;
}
