# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

"""
Ocean の回帰テストを目的としたスクリプトです。
目的の画面への遷移、画像処理による表示の確認、再起動を繰り返し、画面遷移が正常にできるか、表示崩れが無いかなどのチェックを行います。

実行するための前提条件
・「設定」 -> 「ロック」 -> 「画面ロック」を OFF にしている
・記録されたシステムエラーが存在する
"""


import os
import sys

# パス追加
sys.path.append( os.path.dirname(os.path.abspath(__file__)) + "\\..\\" )
sys.path.append( os.path.dirname(os.path.abspath(__file__)) + "\\..\\..\\..\\..\\..\\..\\..\\Externals\\TestBinaries\\AutoTestAssistTool\\OceanAutopilotTest\\" )

# 作業ディレクトリ指定
os.chdir( os.path.dirname(os.path.abspath(__file__)))

import time
import csv

import datetime
import subprocess
from HACMCTDriver import factory, Button, CaptureMode
from kiki.util.log  import file_logger as logger
from params.winpos import WIN_POS
import FileDialog

from scenes.album.t_album import TAlbum
from scenes.common.t_auth import TAuth
from scenes.common.t_psel import TPsel
from scenes.common.t_swkbd import TSwkbd
from scenes.common.user_setting import UserSetting
from scenes.controller_support.t_controller_support import TControllerSupport
from scenes.cruiser.t_cruiser import TCruiser
from scenes.entrance.t_entrance import TEntrance
from scenes.eshop.shopN import ShopN
from scenes.friend_mypage.t_mypage import TMypage
from scenes.home_menu.t_home_menu import THomeMenu
from scenes.main_setting.t_main_setting import TMainSetting
from res.res_path import RES_PATH
from scenes.news_list.t_news_list import TNewsList
from scenes.option_menu.t_option_menu import TOptionMenu
from scenes.setting_mii.t_mii_edit import TMiiEdit
from sequences.NA_operation_seq import unlink_NA_seq, link_NA_seq, is_NA_linked_user_seq
from sequences.SwkbdInputter import SwkbdInputter
from sequences.moon_setting_seq import register_moon_setting, delete_moon_setting
from sequences.togo_register_AP_seq import check_any_available_network_setting, \
    enable_to_registered_AP_connection, togo_register_AP_seq_by_manual_setup
from util.csv_output import Csv_Output
from config.confmgr import CONF


_CONTROL_TARGET_PATH = os.environ["NINTENDO_SDK_ROOT"] + r"\Tools\CommandLineTools\ControlTarget.exe "
_LOG_SERVER_PATH = os.environ["NINTENDO_SDK_ROOT"] + r"\Tools\Log\LogServer\LogServer.exe"
_RUN_ON_TARGET_PATH = os.environ["NINTENDO_SDK_ROOT"] + r"\Tools\CommandLineTools\RunOnTarget.exe"
_DEV_MENU_COMMAND_PATH = os.environ["NINTENDO_SDK_ROOT"] + r"\TargetTools\NX-NXFP2-a64\DevMenuCommand\Release\DevMenuCommand.nsp"
_ICON_IMAGE_PATH = RES_PATH + "/togo_test_cases/"
_na_login_id = ""

def get_execute_test_suites_list():
    f = open(r"../test_case_ID_list.csv", str("rb"))
    data_reader = csv.reader(f)
    # data_reader = csv.reader(f, delimier="\t")

    t_list = []
    for row in data_reader:
        t_list.append(row)

    t_list.pop(0)
    return t_list

def reboot_by_control_target():
    subprocess.call(_CONTROL_TARGET_PATH + "reset")
    time.sleep(10)
    # LogServer.exe 念の為起動
    # TODO:4系NUP作業になったら LogServer.exe 無しでもTargetManagerで接続可能なはずなのでここは消すこと。
    # subprocess.call(_LOG_SERVER_PATH)
    subprocess.call(_CONTROL_TARGET_PATH + "connect")

    _scene = TEntrance(_driver)
    for i in range(30):
        if _scene.is_available():
            time.sleep(3)
            return
        else:
            time.sleep(1)

def connect_all_paired_controllers():
    # 接続対象がフルキーコンなら使える。
    # それ以外ならコントローラーをさがすで指定してあげたほうが確実。
    subprocess.call(_RUN_ON_TARGET_PATH + " " + _DEV_MENU_COMMAND_PATH + " controller connect-all")

def detect_invalid_ukyou_in_find_disconnect_controller(driver):
    # HOMEメニューから開始すること
    _scene = THomeMenu(driver)
    _scene.select_system_applet("controller")

    # コントローラーをさがす を選択
    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)
    time.sleep(2)

    # さがせない状態ではないか( BT_OFF( 機内モード )も検知されるけど今回は割愛 )
    image = _ICON_IMAGE_PATH + "handheld_only.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("探せるコントローラーが存在しません。")
        return False

    image = _ICON_IMAGE_PATH + "too_many_connected_controllers.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("接続済みのコントローラーが多すぎる為、さがすのを断念します。")
        return False

    # 右Joy-Con をさがす
    image_list = [ _ICON_IMAGE_PATH + "search_controller_invalid_ukyou_A.png",
                   _ICON_IMAGE_PATH + "search_controller_invalid_ukyou_B.png" ]

    for i in range(10):
        for j in range(5):
            for image in image_list:
                if driver.screen.detect_object_with_image(image, threshold=0.98) is not None:
                    logger.info("未接続の 右Joy-Con を発見しました。")
                    return True
        if i == 4:
            driver.controllers[0].push("LEFT", ms_press=2000, ms_after=500)
            driver.controllers[0].push("DOWN", ms_after=500)
        else:
            driver.controllers[0].push("RIGHT", ms_after=500)

    logger.info("未接続の 右Joy-Con を発見できませんでした。")
    return False

def get_execute_test_suite_info(index):
    # function_name, 検証開始前にAP接続が必須かどうか
    test_suite_dict = { "2": [ no2_err_app_safety, False ],
                        "3": [ no3_err_app_error_log, False ],
                        "4": [ no4_err_app_eula, False ],
                        "14": [ no14_news_list_from_HOMEmenu, False ],
                        "16": [ no16_news_viewer_from_HOME_menu, False ],
                        "17": [ no17_web_app_from_news, True ],
                        "18": [ no18_shop_from_news, True ],
                        "19": [ no19_psel_from_news, True ],
                        "20": [ no20_login_share_from_news, True ],
                        "21": [ no21_boot_app_from_news, True ],
                        "25": [ no25_network_app_boot_from_opt_update_app, False ],
                        "31": [ no31_psel_from_opt_mnp, True ],
                        "32": [ no32_login_app_from_opt_mnp, True ],
                        "33": [ no33_network_app_boot_from_opt_mnp, False ],
                        "35": [ no35_reference_from_option, False ],
                        "36": [ no36_info_from_option, False ],
                        "37": [ no37_property_from_option, False ],
                        "38": [ no38_shop_jump_from_option, True ],
                        "39": [ no39_psel_from_opt_to_shop, False ],
                        "40": [ no40_login_app_from_opt_to_shop, True ],
                        "41": [ no41_boot_full_launcher, False ],
                        "42": [ no42_auth_boot_from_unlock_btn, False ],
                        "44": [ no44_psel_boot_from_mp_profile, False ],
                        "45": [ no45_psel_boot_from_mp_frilist, False ],
                        "46": [ no46_psel_boot_from_mp_recommend, False ],
                        "47": [ no47_psel_boot_from_mp_add, False ],
                        "48": [ no48_psel_boot_from_mp_setting, False ],
                        "49": [ no49_login_app_boot_from_mp_profile, True ],
                        "50": [ no50_login_app_boot_from_mp_frilist, True ],
                        "51": [ no51_login_app_boot_from_mp_recommend, True ],
                        "52": [ no52_login_app_boot_from_mp_add, True ],
                        "53": [ no53_login_app_boot_from_mp_setting, True ],
                        "54": [ no54_psel_icon_edit_boot_from_mp_profile, False ],
                        "55": [ no55_mii_boot_from_mp_profile, False ],
                        "56": [ no56_boot_app_from_mp_play_log, True ],
                        "57": [ no57_boot_app_from_friend_play_log, True ],
                        "58": [ no58_shop_boot_from_friend_play_log, True ],
                        "59": [ no59_psel_boot_from_HOMEmenu, False ],
                        "60": [ no60_login_app_from_shop, True ],
                        "61": [ no61_shop_boot_from_HOMEmenu, True ],
                        "62": [ no62_scoop_boot_from_HOMEmenu, False ],
                        "63": [ no63_psel_boot_from_scoop_post, False ],
                        "64": [ no64_login_app_boot_from_scoop_post, True ],
                        "65": [ no65_share_app_boot_from_scoop_post, True ],
                        "66": [ no66_controller_support_boot_from_HOMEmenu, False ],
                        "70": [ no70_psel_boot_from_news_search_channel, True ],
                        "71": [ no71_login_app_boot_from_news_search_channel, True ],
                        "74": [ no74_auth_boot_from_parental_control, False ],
                        "75": [ no75_network_app_boot_from_internet_setting, False ],
                        "77": [ no77_auth_boot_from_internet_setting, False ],
                        "78": [ no78_web_app_boot_from_parental_control, True ],
                        "79": [ no79_data_erase_boot_from_main_setting, False ],
                        "80": [ no80_auth_boot_from_delete_save_data, False ],
                        "81": [ no81_auth_boot_from_delete_ss_all_NAND, False ],
                        "82": [ no82_auth_boot_from_delete_ss_all_SD, False ],
                        "83": [ no83_scoop_viewer_boot_from_main_setting, False ],
                        "84": [ no84_swkbd_boot_from_users, False ],
                        "85": [ no85_login_app_boot_from_users, False ],
                        "86": [ no86_swkbd_boot_from_add_user, False ],
                        "87": [ no87_swkbd_boot_from_mii_edit, False ],
                        "88": [ no88_mii_edit_boot_from_add_user, False ],
                        "89": [ no89_cabinet_boot_from_add_user, False ],
                        "90": [ no90_auth_boot_from_delete_user, False ],
                        "91": [ no91_block_list_from_users, True ],
                        "92": [ no92_block_list_from_mypage, True ],
                        "93": [ no93_sns_setting_from_users, True ],
                        "94": [ no94_shop_setting_from_users, True ],
                        "95": [ no95_mii_edit_boot_from_main_setting, False ],
                        "96": [ no96_cabinet_boot_from_main_setting, False ],
                        "97": [ no97_controller_support_boot_from_main_setting, False ],
                        "98": [ no98_auth_boot_from_region, False ],
                        "99": [ no99_auth_boot_from_date_and_time, False ],
                        "100": [ no100_auth_boot_from_lower_max_headphone_volume, False ],
                        "101": [ no101_network_app_boot_from_system_update, False ],
                        "103": [ no103_swkbd_boot_from_console_nickname, False ],
                        "104": [ no104_offline_web_app_boot_from_intellectual_property_notices, False ],
                        "105": [ no105_err_app_eula_from_main_setting, False ],
                        "106": [ no106_login_app_boot_from_news_setting, True ],
                        "107": [ no107_auth_boot_from_initialize, False ],
                        "108": [ no108_psel_boot_from_reset_cache, False ],
                        "109": [ no109_psel_boot_from_reset_keyboard, False ],
                        "111": [ no111_psel_boot_from_users_add_new_user, False ],
                        "113": [ no113_psel_boot_from_only_aoc_title, False ],
                        "114": [ no114_login_app_boot_from_only_aoc_title, True ],
                        "115": [ no115_shop_boot_from_only_aoc_title, True ],
                        "118": [ no118_psel_boot_from_application, False ],
                        "119": [ no119_login_app_boot_from_application, True ],
                        "120": [ no120_err_app_boot_from_apps_rating, False ],
                        "121": [ no121_network_app_boot_from_drm_check, True ],
                        "124": [ no124_err_app_boot_from_drm_check, True ] }

    return test_suite_dict[index]

def get_cur_time_str():
    now = datetime.datetime.now()
    return now.strftime('%Y/%m/%d %H:%M:%S')

def make_result_list(result, message=""):
    result_list = [result, get_cur_time_str(), message]
    return result_list

def initialize_cursor_position_in_HOME_menu(driver, id=0):
    driver.controllers[id].push("HOME", ms_after=1000)
    time.sleep(2)

def no2_err_app_safety(driver):
    # HOMEから設定を選択
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # サポートを選択
    _scene = TMainSetting(driver)
    for i in range(20):
        if _scene.is_available():
            _scene.select_left_menu_by_keys("サポート")
            break
        else:
            time.sleep(1)
    else:
        # 遷移失敗
        mes = "設定への遷移に失敗。"
        logger.info(mes)
        return make_result_list("NG", message=mes)

    # 安全に使用するためにを選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(2)
    image = _ICON_IMAGE_PATH + "no2_err_app_safety.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】安全に使用するために へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "安全に使用するために へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)


def no3_err_app_error_log(driver):
    # HOMEから設定を選択
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # サポートを選択
    _scene = TMainSetting(driver)
    if _scene.is_available():
        _scene.select_left_menu_by_keys("サポート")
    else:
        # 遷移失敗
        mes = "設定への遷移に失敗。"
        logger.info(mes)
        return make_result_list("NG", message=mes)

    # エラー履歴を選択
    driver.controllers[0].push("DOWN", ms_press=2000, ms_after=500)
    driver.controllers[0].push("A", ms_after=500)

    # エラー一覧画面で任意のエラーを選択する
    driver.controllers[0].push("A", ms_after=500)

    # 「エラーの内容を見る」選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no3_err_app_error_log.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】エラー詳細画面 へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "エラー詳細画面 へ遷移できませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no4_err_app_eula(driver):
    # HOMEから設定を選択
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # 本体を選択
    _scene = TMainSetting(driver)
    if _scene.is_available():
        _scene.select_left_menu_by_keys("本体")
    else:
        # 遷移失敗
        mes = "設定への遷移に失敗。"
        logger.info(mes)
        return make_result_list("NG", message=mes)

    # 地域を選択する
    for i in range(3):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 地域を変更する( JP -> US )
    driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 利用規約( または重要な情報を見る )を選択する
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no4_err_app_eula.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】利用規約 へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "利用規約 へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no13_news_list_from_entrance(driver):
    # スリープイン
    _scene = THomeMenu(driver)
    _scene.transit_to_sleep_mode()
    time.sleep(10)

    # ウェイク
    _scene = TEntrance(driver)
    _scene.wake_by_power_button()

    # Yを押す(ゲームニュースリストへ)
    for i in range(15):
        if _scene.is_available():
            driver.controllers[0].push("Y", ms_after=2000)
            break
        else:
            time.sleep(1)
    else:
        # ウェイク失敗？
        mes = "スリープ後のエントランスへの復帰に失敗"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no13_no14_news_list.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】エントランスからニュース一覧 へ遷移しました。")
    else:
        logger.info("【NG】エントランスからニュース一覧 へ遷移できませんでした。")


def no14_news_list_from_HOMEmenu(driver):
    # MENU上のゲームニュースボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("news_list")

    # 整合性確認
    time.sleep(1)
    image = _ICON_IMAGE_PATH + "no13_no14_news_list.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】HOMEメニューからニュース一覧 へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "HOMEメニューからニュース一覧 へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no16_news_viewer_from_HOME_menu(driver):
    # 統合チーム自動テスト用1 を使用。
    # ニュースボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("news_list")

    # 既定のニュースを選択
    _scene = TNewsList(driver)
    if not _scene.transit_to_news_detail("news_thumbnail_1.png"):
        mes = "統合チーム自動テスト用1 のニュースが発見できませんでした。"
        logger.info(mes)
        return make_result_list("NG", message=mes)

    # 整合性確認
    time.sleep(1)
    image = _ICON_IMAGE_PATH + "togo_news_01_identity.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】既定のニュース詳細画面 へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "既定のニュース詳細画面 へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no17_web_app_from_news(driver):
    # 統合チーム自動テスト用2 を使用。
    # ニュースボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("news_list")

    # 既定のニュースを選択
    _scene = TNewsList(driver)
    if not _scene.transit_to_news_detail("news_thumbnail_2.png"):
        mes = "統合チーム自動テスト用2 のニュースが発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 動画 を選択
    time.sleep(1)
    image = _ICON_IMAGE_PATH + "togo_news_02_identity.png"
    if driver.screen.detect_object_with_image(image) is None:
        mes = "既定のニュース詳細画面 へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_movie_player():
        logger.info("【OK】webアプレット(動画再生) へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "webアプレット(動画再生) へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no18_shop_from_news(driver):
    # 統合チーム自動テスト用1 を使用する。
    # ネット接続有無確認、なければAPを1個登録する
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")
    driver.controllers[0].push("A", ms_after=1000)
    if _scene.check_any_registered_AP():
        togo_register_AP_seq_by_manual_setup(driver)
    driver.controllers[0].push("HOME", ms_after=1000)

    # NA連携確認、なければNA連携＆ショップログイン
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)
    _scene = TMypage(driver)
    if not _scene.is_NA_linked_user():
        driver.controllers[0].push("A", ms_after=1000)
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)

        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
    driver.controllers[0].push("HOME", ms_after=1000)

    # ニュースボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("news_list")

    # 既定のニュースを選択
    _scene = TNewsList(driver)
    if not _scene.transit_to_news_detail("news_thumbnail_1.png"):
        mes = "既定のニュースの詳細画面 へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # ショップへジャンプできるボタンを押す
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # NAを選択
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    image = _ICON_IMAGE_PATH + "shop_BAAWA_app_info_identity.png"
    for i in range(60):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】ショップ商品詳細ページ へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "ショップ商品詳細ページ へ遷移できませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no19_psel_from_news(driver):
    # 統合チーム自動テスト用1 を使用する。
    # ニュースボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("news_list")

    # 既定のニュースを選択
    _scene = TNewsList(driver)
    _scene.transit_to_news_detail("news_thumbnail_1.png")

    # ショップへジャンプできるボタンを押す
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no39_psel_from_opt_to_shop.png"
    for i in range(60):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "アカウント管理アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no20_login_share_from_news(driver):
    # 統合チーム自動テスト用1 を使用
    # ネット接続の有無確認、なければAP登録
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")
    driver.controllers[0].push("A", ms_after=1000)
    if _scene.check_any_registered_AP():
        togo_register_AP_seq_by_manual_setup(driver)
    driver.controllers[0].push("HOME", ms_after=1000)

    # ニュースボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("news_list")

    # 既定のニュースを選択
    _scene = TNewsList(driver)
    _scene.transit_to_news_detail("news_thumbnail_1.png")

    # ショップへジャンプできるボタンを押す
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # UA を選択
    time.sleep(2)
    driver.controllers[0].push("RIGHT", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # web 認証を通過する
    _scene.input_user_authentication(save_flg=False)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no21_boot_app_from_news(driver):
    # 統合チーム自動テスト用1 を使用する。
    # NA連携の有無確認、なければ連携する
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)
    _scene = TMypage(driver)
    if not _scene.is_NA_linked_user():
        time.sleep(1)
        driver.controllers[0].push("A", ms_after=1000)
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
        time.sleep(3)
    driver.controllers[0].push("HOME", ms_after=1000)

    # Shopログイン
    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)
    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    _scene.is_available() # 遷移先がどこであれ起動は完了しているはず
    driver.controllers[0].push("HOME", ms_after=1000)

    time.sleep(2)

    # ニュースボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("news_list")

    # 既定のニュースを選択
    _scene = TNewsList(driver)
    _scene.transit_to_news_detail("news_thumbnail_1.png")

    # アプリへのジャンプボタンを押す
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "dummy_0100de4001990000_identity.png"
    for i in range(30):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】ニュースからアプリ へ遷移しました")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "ニュースからアプリ へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no22_resume_app_from_entrance(driver):
    # 任意のアプリを起動させる
    _scene = THomeMenu(driver)
    image_list = [ _ICON_IMAGE_PATH + "dummy_01000dd001e70000_A.png",
                   _ICON_IMAGE_PATH + "dummy_01000dd001e70000_B.png" ]
    if not _scene.boot_app_from_qlaunch(image_list):
        mes = "起動予定のアプリを発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("A", ms_after=1000)
    time.sleep(4)
    cap_image = driver.screen.get_roi()

    # スリープに入る
    driver.hardware_em.press_power_button(1)
    # driver.controllers[0].push("HOME", ms_after=1000)
    # _scene.select_system_applet("sleep")
    # driver.controllers[0].push("A", ms_after=1000)
    time.sleep(9)

    # ウェイクしてエントランスを表示させる
    _scene = TEntrance(driver)
    _scene.wake_by_power_button()
    # driver.controllers[0].push("HOME", ms_after=1000)
    if not _scene.is_available():
        mes = "エントランスが表示されていません。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # つづける を選択する
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(2)
    if driver.screen.detect_object_with_image(cap_image) is not None:
        logger.info("【OK】中断したアプリが再開されました。")
    else:
        logger.info("【NG】中断したアプリが再開されませんでした。")


def no23_boot_HOMEmenu(driver):
    # HOMEメニュー上でスリープに入る
    driver.hardware_em.press_power_button(1)
    time.sleep(9)

    # スリープから復帰しエントランスを表示させる
    _scene = TEntrance(driver)
    _scene.wake_by_power_button()
    if not _scene.is_available():
        mes = "エントランスが表示されていません。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # つづける を選択する
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = THomeMenu(driver)
    if _scene.is_available():
        logger.info("【OK】HOMEメニューへ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "HOMEメニューへ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)


def no24_resume_main_setting(driver):
    # 本体設定へ遷移
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # スリープに入る
    _scene = TMainSetting(driver)
    if _scene.is_available():
        driver.hardware_em.press_power_button(1)
        time.sleep(9)
    else:
        mes = "本体設定へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # スリープから復帰しエントランスを表示させる
    _scene = TEntrance(driver)
    _scene.wake_by_power_button()
    if not _scene.is_available():
        mes = "エントランスが表示されていません。"
        logger.info("【NG】{0}".format("NG", message=mes))
        return make_result_list("NG", message=mes)

    # つづける を選択する
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TMainSetting(driver)
    if _scene.is_available() is not None:
        logger.info("【OK】本体設定へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "本体設定へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no25_network_app_boot_from_opt_update_app(driver):
    # ネット接続の有無確認。あれば登録AP数を0にする
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")
    driver.controllers[0].push("A", ms_after=1000)
    _scene.is_transited_to_AP_list()
    for i in range(32):
        if _scene.check_any_registered_AP():
            break
        else:
            _scene.delete_registered_AP()
    driver.controllers[0].push("HOME", ms_after=1000)

    # アプリアイコン上で +ボタンを押す
    driver.controllers[0].push("START", ms_after=1000)

    # ソフトの更新 を選択
    # インターネットで更新 を選択
    _scene = TOptionMenu(driver)
    _scene.select_menu("インターネットで更新")

    # インターネット設定へ を選択
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "search_network_header.png"
    result = []
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            _scene = TMainSetting(driver)
            if _scene.is_transited_to_AP_list():
                logger.info("【OK】ネット接続アプレット へ遷移しました。")
                result = make_result_list("OK")
                break
            else:
                time.sleep(1)
    else:
        mes = "ネット接続アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)


    # AP登録
    _scene.is_transited_to_AP_list()
    togo_register_AP_seq_by_manual_setup(driver)
    return result


def no31_psel_from_opt_mnp(driver):
    # カードアプリアイコン上で + / - ボタンを押す
    _scene = THomeMenu(driver)
    if not _scene.search_card_title():
        mes = "カード版のダミーアプリを見つけることが出来ませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("START", ms_after=1000)

    # MNPを選択
    for i in range(3):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)
    # driver.controllers[0].push("A", ms_after=1000)

    # ポイントを受け取る(パッケージ版)を選ぶ
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no31_psel_from_opt_mnp.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no32_login_app_from_opt_mnp(driver):
    # カードアプリアイコン上で + / - ボタンを押す
    _scene = THomeMenu(driver)
    if not _scene.search_card_title():
        mes = "カード版のダミーアプリを見つけることが出来ませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("START", ms_after=1000)

    # MNPを選択
    for i in range(3):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)
    # driver.controllers[0].push("A", ms_after=1000)

    # ポイントを受け取る(パッケージ版)を選ぶ
    driver.controllers[0].push("A", ms_after=1000)

    # UAを選択
    image = _ICON_IMAGE_PATH + "no31_psel_from_opt_mnp.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            break
        else:
            time.sleep(1)
    else:
        mes = "psel へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("RIGHT", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】アカウントログイン へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログイン へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no33_network_app_boot_from_opt_mnp(driver):
    # ネット接続の有無確認、あれば登録AP数を0にする
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")
    _scene = TMainSetting(driver)
    _scene.is_available()
    _scene.select_left_menu_by_keys("インターネット")
    driver.controllers[0].push("A", ms_after=1000)

    _scene.is_transited_to_AP_list()
    for i in range(32):
        if _scene.check_any_registered_AP():
            break
        else:
            _scene.delete_registered_AP()
    driver.controllers[0].push("HOME", ms_after=1000)

    # カードアプリアイコン上で + ボタンを押す
    _scene = THomeMenu(driver)
    _scene.search_card_title()
    driver.controllers[0].push("START", ms_after=1000)

    # MNPを選択
    # ポイントを受け取る(パッケージ版のみ)を選択
    _scene = TOptionMenu(driver)
    _scene.select_menu("ポイントを受け取る")

    # インターネット設定へ を選択する
    time.sleep(4)
    _driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    result = []
    image = _ICON_IMAGE_PATH + "search_network_header.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            _scene = TMainSetting(driver)
            if _scene.is_transited_to_AP_list():
                logger.info("【OK】ネット接続アプレット へ遷移しました。")
                result = make_result_list("OK")
                break
            else:
                time.sleep(1)
    else:
        mes = "ネット接続アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # AP登録
    _scene = TMainSetting(driver)
    _scene.is_transited_to_AP_list()
    togo_register_AP_seq_by_manual_setup(driver)
    return result

def no35_reference_from_option(driver):
    # カードアプリアイコン上で + / - ボタンを押す
    _scene = THomeMenu(driver)
    if not _scene.search_card_title():
        mes = "カード版のダミーアプリを見つけることが出来ませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("START", ms_after=1000)

    # ソフトの情報 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # お問い合わせ先 を選択
    driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no35_reference_from_option.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】お問い合わせ先 へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "お問い合わせ先 へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)


def no36_info_from_option(driver):
    # カードアプリアイコン上で + / - ボタンを押す
    _scene = THomeMenu(driver)
    if not _scene.search_card_title():
        mes = "カード版のダミーアプリを見つけることが出来ませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("START", ms_after=1000)

    # ソフトの情報 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 重要な情報 を選択
    for i in range(2):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no36_info_from_option.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】重要な情報 へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "重要な情報 へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)


def no37_property_from_option(driver):
    # カードアプリアイコン上で + / - ボタンを押す
    _scene = THomeMenu(driver)
    if not _scene.search_card_title():
        mes = "カード版のダミーアプリを見つけることが出来ませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("START", ms_after=1000)

    # ソフトの情報 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 知的財産の表記 を選択
    for i in range(3):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no37_property_from_option.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】知的財産の表記 へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "知的財産の表記 へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)


def no38_shop_jump_from_option(driver):
    # NAの有無確認、なければNA紐付とショップログイン
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = TMypage(driver)
    if not _scene.is_NA_linked_user():
        driver.controllers[0].push("A", ms_after=1000)
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)

        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)

    # カードアプリアイコン上で +/- ボタンを押す( =ショップ販売中アプリ )
    time.sleep(2)
    driver.controllers[0].push("HOME", ms_after=1000)

    time.sleep(2)
    _scene = THomeMenu(driver)
    if not _scene.search_card_title():
        mes = "カード版のダミーアプリを見つけることが出来ませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("START", ms_after=1000)

    # ソフトの情報 を選択
    driver.controllers[0].push("A", ms_after=500)

    # ニンテンドーeショップへ を選択
    driver.controllers[0].push("A", ms_after=1000)

    # NAの紐付いたアカウント を選択
    image = _ICON_IMAGE_PATH + "no39_psel_from_opt_to_shop.png"
    for i in range(30):
        if driver.screen.detect_object_with_image(image) is not None:
            driver.controllers[0].push("A", ms_after=1000)
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント選択アプレット が起動しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    image = _ICON_IMAGE_PATH + "no38_shop_jump_from_option.png"
    for i in range(30):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】ニンテンドーeショップ 商品詳細ページへ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "ニンテンドーeショップ 商品詳細ページへ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)


def no39_psel_from_opt_to_shop(driver):
    # 任意のアプリアイコン上で +/- ボタンを押す
    _scene = THomeMenu(driver)
    driver.controllers[0].push("START", ms_after=1000)

    # ソフトの情報 を選択
    driver.controllers[0].push("A", ms_after=500)

    # ニンテンドーeショップへ を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no39_psel_from_opt_to_shop.png"
    for i in range(30):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント選択アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "アカウント選択アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)


def no40_login_app_from_opt_to_shop(driver):
    # ネット接続の有無確認、なければAP登録数1にする
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")
    _scene = TMainSetting(driver)
    _scene.is_available()
    _scene.select_left_menu_by_keys("インターネット")
    driver.controllers[0].push("A", ms_after=1000)

    _scene.is_transited_to_AP_list()
    if _scene.check_any_registered_AP():
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # 任意のアプリアイコン上で +/- ボタンを押す
    _scene = THomeMenu(driver)
    driver.controllers[0].push("START", ms_after=1000)

    # ソフトの情報 を選択
    driver.controllers[0].push("A", ms_after=500)

    # ニンテンドーeショップへ を選択
    driver.controllers[0].push("A", ms_after=1000)

    # UA を選択
    image = _ICON_IMAGE_PATH + "no39_psel_from_opt_to_shop.png"
    for i in range(30):
        if driver.screen.detect_object_with_image(image) is not None:
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント選択アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    time.sleep(1)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # Web認証を通過する
    _scene.input_user_authentication()

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no41_boot_full_launcher(driver):
    # フルランチャー起動アイコンを押す
    driver.controllers[0].push("RIGHT", ms_press=2000, ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no41_boot_full_launcher.png"
    for i in range(5):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】フルランチャー へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "フルランチャー へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no42_auth_boot_from_unlock_btn(driver):
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        register_moon_setting(driver, "None")

    # みまもり制限解除のボタンを押す
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_press=2000, ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    result = []
    image = _ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png"
    for i in range(5):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】簡易認証アプレット へ遷移しました。")
            result = make_result_list("OK")
            break
        else:
            time.sleep(1)
    else:
        mes = "簡易認証アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # みまもり設定を削除
    driver.controllers[0].push("HOME", ms_after=1000)
    delete_moon_setting(driver)
    return result

def no44_psel_boot_from_mp_profile(driver):
    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # プロフィール を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("プロフィール")

    # ニンテンドーアカウントと連携 を選択
    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no45_psel_boot_from_mp_frilist(driver):
    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # フレンドリスト を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("フレンドリスト")

    # フレンドを追加 を選択
    _driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no46_psel_boot_from_mp_recommend(driver):
    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # フレンドになれるかも？ を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("フレンドになれるかも？")

    # ニンテンドーアカウントと連携 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no47_psel_boot_from_mp_add(driver):
    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # フレンド追加 を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("フレンド追加")

    # ニンテンドーアカウントと連携 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no48_psel_boot_from_mp_setting(driver):
    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ユーザー設定 を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("ユーザー設定")

    # ニンテンドーアカウントと連携 を選択
    driver.controllers[0].push("DOWN", ms_press=1000, ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no49_login_app_boot_from_mp_profile(driver):
    # ネット接続の有無確認、なければAP登録数1にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # プロフィール を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("プロフィール")

    # ニンテンドーアカウントと連携 を選択
    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # Web認証( Basic認証 )を通過する
    if not _scene.input_user_authentication():
        mes = "ユーザー認証を通過できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no50_login_app_boot_from_mp_frilist(driver):
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # フレンドリスト を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("フレンドリスト")

    # ニンテンドーアカウントと連携 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # Web認証( Basic認証 )を通過する
    if not _scene.input_user_authentication():
        mes = "ユーザー認証を通過できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no51_login_app_boot_from_mp_recommend(driver):
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # フレンドになれるかも？ を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("フレンドになれるかも？")

    # ニンテンドーアカウントと連携 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # Web認証( Basic認証 )を通過する
    if not _scene.input_user_authentication():
        mes = "ユーザー認証を通過できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no52_login_app_boot_from_mp_add(driver):
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # フレンド追加 を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("フレンド追加")

    # ニンテンドーアカウントと連携 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # Web認証( Basic認証 )を通過する
    if not _scene.input_user_authentication():
        mes = "ユーザー認証を通過できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no53_login_app_boot_from_mp_setting(driver):
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # UA を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ユーザー設定 を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("ユーザー設定")

    # ニンテンドーアカウントと連携 を選択
    driver.controllers[0].push("DOWN", ms_press=1500, ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # Web認証( Basic認証 )を通過する
    if not _scene.input_user_authentication():
        mes = "ユーザー認証を通過できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no54_psel_icon_edit_boot_from_mp_profile(driver):
    # アカウントアイコン を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # プロフィール を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("プロフィール")

    # アイコンの編集 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no54_psel_icon_edit_boot_from_mp_profile.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット( アイコン編集 ) へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット( アイコン編集 ) へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no55_mii_boot_from_mp_profile(driver):
    # アカウントアイコン を選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # プロフィール を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("プロフィール")

    # アイコンの編集 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # キャラクター/Mii を選択
    time.sleep(1)
    driver.controllers[0].push("A", ms_after=1000)

    # Mii を選択
    driver.controllers[0].push("DOWN", ms_press=2000, ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TMiiEdit(driver)
    if _scene.is_available():
        logger.info("【OK】Miiスタジオアプレット へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "Miiスタジオアプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no56_boot_app_from_mp_play_log(driver):
    # Ocean Debug Tool( 通常版 ) ( 01005cb00006a000 )を使用。検証本体にDLしておくこと。
    # NA連携の有無確認、なければ連携する
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)
    _scene = TMypage(driver)
    if not _scene.is_NA_linked_user():
        driver.controllers[0].push("A", ms_after=1000)
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
        time.sleep(3)
    driver.controllers[0].push("HOME", ms_after=1000)

    # Shopログイン
    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)
    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    _scene.is_available() # 遷移先がどこであれ起動は完了しているはず
    driver.controllers[0].push("HOME", ms_after=1000)

    time.sleep(2)

    # NAのアイコン 選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # プロフィール を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("プロフィール")

    # プレイ履歴( 最大20件 )から任意のアプリを選択
    image_path_list = [ _ICON_IMAGE_PATH + "pl_ocean_debug_tool_A.png",
                        _ICON_IMAGE_PATH + "pl_ocean_debug_tool_B.png" ]

    if not _scene.select_app_from_play_log(image_path_list):
        mes = "起動対象のアプリアイコンが発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("A", ms_after=1000) # このソフトをはじめます。で はじめる 選択
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000) # psel で NA を選択

    # 整合性確認
    image = _ICON_IMAGE_PATH + "ocean_debug_tool_identity.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アプリ へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    mes = "アプリ へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no57_boot_app_from_friend_play_log(driver):
    # NA連携の有無確認、なければ連携する
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)
    _scene = TMypage(driver)
    if not _scene.is_NA_linked_user():
        driver.controllers[0].push("A", ms_after=1000)
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
        time.sleep(3)
    driver.controllers[0].push("HOME", ms_after=1000)

    # Shopログイン
    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)
    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    _scene.is_available() # 遷移先がどこであれ起動は完了しているはず
    driver.controllers[0].push("HOME", ms_after=1000)

    time.sleep(2)

    # NA のアイコン 選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # フレンドリスト を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("フレンドリスト")

    # フレンドの NA を選択
    driver.controllers[0].push("A", ms_after=1000)

    # プレイ記録 から任意のアプリを選択
    driver.controllers[0].push("RIGHT", ms_after=1000)

    image_path_list = [ _ICON_IMAGE_PATH + "pl_ocean_debug_tool_A.png",
                        _ICON_IMAGE_PATH + "pl_ocean_debug_tool_B.png" ]

    if not _scene.select_app_from_play_log(image_path_list):
        mes = "起動対象のアプリアイコンが発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("A", ms_after=1000) # このソフトをはじめます。で はじめる 選択
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000) # psel で NA を選択

    # 整合性確認
    image = _ICON_IMAGE_PATH + "ocean_debug_tool_identity.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アプリ へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    mes = "アプリ へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no58_shop_boot_from_friend_play_log(driver):
    # U-King( 01007ef00011e000 / イニシャルコード: AAAAA )を使用。検証本体にDLしないこと。
    # NAのアイコン 選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # フレンドリスト を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページへ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("フレンドリスト")

    # フレンドの NA を選択
    driver.controllers[0].push("A", ms_after=1000)

    # プレイ記録 から任意のアプリを選択
    driver.controllers[0].push("RIGHT", ms_after=1000)
    img_paths = [ _ICON_IMAGE_PATH + "pl_AAAAA_A.png",
                  _ICON_IMAGE_PATH + "pl_AAAAA_B.png" ]
    if not _scene.select_app_from_play_log(img_paths):
        mes = "プレイ記録より目的のアプリが発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "shop_AAAAA_app_info_identity.png"
    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    for i in range(60):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】shopN へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "shopN へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no59_psel_boot_from_HOMEmenu(driver):
    # ニンテンドーeshop ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no39_psel_from_opt_to_shop.png"
    time.sleep(2)
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】アカウント管理アプレット へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no60_login_app_from_shop(driver):
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # ニンテンドーeshopボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")

    # psel で UA を選択
    image = _ICON_IMAGE_PATH + "no39_psel_from_opt_to_shop.png"
    time.sleep(2)
    if driver.screen.detect_object_with_image(image) is None:
        mes = "ショップ選択後の アカウント管理アプレット が起動しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # Web認証を通過する
    if not _scene.input_user_authentication():
        mes = "Web認証画面 へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no61_shop_boot_from_HOMEmenu(driver):
    # ニンテンドーeshop ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")

    # psel で NA を選択
    image = _ICON_IMAGE_PATH + "no39_psel_from_opt_to_shop.png"
    time.sleep(2)
    if driver.screen.detect_object_with_image(image) is None:
        mes = "ショップ選択後の アカウント管理アプレット が起動しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    if _scene.is_available():
        logger.info("【OK】shopN のトップページへ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "shopN のトップページへ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no62_scoop_boot_from_HOMEmenu(driver):
    # 画面写真が1枚以上必要
    driver.controllers[0].push("CAPTURE", ms_after=1000)

    # アルバムボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("album")

    # 整合性確認
    time.sleep(2)
    _scene = TAlbum(driver)
    if _scene.is_available():
        logger.info("【OK】アルバム へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アルバム へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no63_psel_boot_from_scoop_post(driver):
    # 画面写真が1枚以上必要
    driver.controllers[0].push("CAPTURE", ms_after=1000)

    # アルバムから任意の写真を選択
    _scene = THomeMenu(driver)
    _scene.select_system_applet("album")

    time.sleep(2)
    _scene = TAlbum(driver)
    if not _scene.is_available():
        mes = "アルバム へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("A", ms_after=1000)

    # 投稿 を選択
    time.sleep(2)
    for i in range(2):
        driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no63_psel_boot_from_scoop_post.png"
    for i in range(5):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no64_login_app_boot_from_scoop_post(driver):
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # 画面写真が1枚以上必要
    driver.controllers[0].push("CAPTURE", ms_after=1000)

    # アルバムから任意の写真を選択
    _scene = THomeMenu(driver)
    _scene.select_system_applet("album")

    time.sleep(2)
    _scene = TAlbum(driver)
    if not _scene.is_available():
        mes = "アルバム へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("A", ms_after=1000)

    # 投稿 を選択
    time.sleep(2)
    for i in range(2):
        driver.controllers[0].push("A", ms_after=1000)

    # UA を選択
    image = _ICON_IMAGE_PATH + "no63_psel_boot_from_scoop_post.png"
    for i in range(5):
        if driver.screen.detect_object_with_image(image) is not None:
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("LEFT", ms_press=1000, ms_after=1000)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    time.sleep(2)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # web認証を通過する
    if not _scene.input_user_authentication():
        mes = "ユーザー認証 へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no65_share_app_boot_from_scoop_post(driver):
    # 画面写真が1枚以上必要
    driver.controllers[0].push("CAPTURE", ms_after=1000)

    # アルバムから任意の写真を選択
    _scene = THomeMenu(driver)
    _scene.select_system_applet("album")

    time.sleep(2)
    _scene = TAlbum(driver)
    if not _scene.is_available():
        mes = "アルバム へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    driver.controllers[0].push("A", ms_after=1000)

    # 投稿 を選択
    time.sleep(2)
    for i in range(2):
        driver.controllers[0].push("A", ms_after=1000)

    # NA を選択
    image = _ICON_IMAGE_PATH + "no63_psel_boot_from_scoop_post.png"
    for i in range(5):
        if driver.screen.detect_object_with_image(image) is not None:
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("LEFT", ms_press=1000, ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_share_select_service():
        logger.info("【OK】Shareアプレット へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "Shareアプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no66_controller_support_boot_from_HOMEmenu(driver):
    # コントローラーボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("controller")

    # 整合性確認
    _scene = TControllerSupport(driver)
    if _scene.is_available():
        logger.info("【OK】コントローラーサポート へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "コントローラーサポート へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no67_sleep_from_HOMEmenu(driver):
    # スリープ を押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("sleep")

    time.sleep(1)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(8)
    if driver.screen.is_on_signal():
        logger.info("【OK】スリープ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "スリープ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no68_sleep_from_quick_setting(driver):
    # クイック設定を開く
    driver.controllers[0].push("HOME", ms_press=600, ms_after=1000)

    # スリープ を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(8)
    if driver.screen.is_on_signal():
        logger.info("【OK】スリープ へ遷移しました。")
    else:
        logger.info("【NG】スリープ へ遷移しませんでした。")

def no69_sleep_by_press_power_btn(driver):
    # 電源ボタンを短押しする
    driver.hardware_em.press_power_button(1)

    # 整合性確認
    time.sleep(8)
    if driver.screen.is_on_signal():
        logger.info("【OK】スリープ へ遷移しました。")
    else:
        logger.info("【NG】スリープ へ遷移しませんでした。")

def no70_psel_boot_from_news_search_channel(driver):
    # 機器認証も解除されるので、実行するのは極力テストケース群の最後のほう
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # NA紐付解除
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = TMypage(driver)
    _scene.is_available() # こけててもこの先わかる。
    if _scene.is_NA_linked_user():
        driver.controllers[0].push("HOME", ms_after=1000)
        _scene = THomeMenu(driver)
        _scene.select_system_applet("main_setting")
        time.sleep(1)
        _scene = TMainSetting(driver)
        _scene.select_left_menu_by_keys("ユーザー")

        driver.controllers[0].push("A", ms_after=1000)
        if not unlink_NA_seq(driver):
            mes = "NA連携解除に失敗しました。"
            logger.info("【NG】{0}".format(mes))
            return make_result_list("NG", message=mes)

    else:
        driver.controllers[0].push("HOME", ms_after=1000)

    # ニュース一覧画面を表示
    _scene = THomeMenu(driver)
    _scene.select_system_applet("news_list")

    # チャンネルを見つける ボタンを押す
    time.sleep(3)
    _scene = TNewsList(driver)
    _scene.transit_to_search_channel()
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(2)
    result = []
    image = _ICON_IMAGE_PATH + "no70_psel_boot_from_news_search_channel.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】アカウント管理アプレット へ遷移しました。")
        result = make_result_list("OK")
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # NA紐付
    driver.controllers[0].push("HOME", ms_after=1000)
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = TMypage(driver)
    _scene.select_navi_bar("フレンドリスト")
    driver.controllers[0].push("A", ms_after=1000)
    time.sleep(2)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)

    # ショップログイン
    time.sleep(2)
    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    return result

def no71_login_app_boot_from_news_search_channel(driver):
    # 機器認証も解除されるので、実行するのは極力テストケース群の最後のほう
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # NA紐付解除
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = TMypage(driver)
    _scene.is_available()  # こけててもこの先わかる。
    if _scene.is_NA_linked_user():
        logger.info("NAをアンリンクします。")
        driver.controllers[0].push("HOME", ms_after=1000)
        _scene = THomeMenu(driver)
        _scene.select_system_applet("main_setting")
        time.sleep(1)
        _scene = TMainSetting(driver)
        _scene.select_left_menu_by_keys("ユーザー")

        driver.controllers[0].push("A", ms_after=1000)
        if not unlink_NA_seq(driver):
            mes = "NA連携解除に失敗しました。"
            logger.info("【NG】{0}".format(mes))
            return make_result_list("NG", message=mes)

    else:
        driver.controllers[0].push("HOME", ms_after=1000)

    # ニュース一覧画面を表示
    _scene = THomeMenu(driver)
    _scene.select_system_applet("news_list")

    # チャンネルを見つける ボタンを押す
    time.sleep(3)
    _scene = TNewsList(driver)
    _scene.transit_to_search_channel()
    driver.controllers[0].push("A", ms_after=1000)

    # 最終的にNAを紐付けるUAを選択
    time.sleep(2)
    image = _ICON_IMAGE_PATH + "no70_psel_boot_from_news_search_channel.png"
    if driver.screen.detect_object_with_image(image) is None:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    if not _scene.input_user_authentication(save_flg=True):
        mes = "ユーザー認証での操作に問題がありました"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    _scene = TCruiser(driver)
    result = []
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        result = make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # NA紐付
    for i in range(2):
        driver.controllers[0].push("A", ms_after=1000)

    _si = SwkbdInputter(driver, strings=_na_login_id)
    _si.run()

    _si = SwkbdInputter(driver, strings="")
    _si.run()

    _scene = TPsel(driver)
    _scene.check_complete_linked_NA()
    driver.controllers[0].push("HOME", ms_after=1000)

    # ショップログイン
    time.sleep(2)
    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    return result

def no74_auth_boot_from_parental_control(driver):
    # みまもり設定の有無を確認、あった場合には削除する
    _scene = THomeMenu(driver)
    if _scene.check_already_registered_parental_control():
        delete_moon_setting(driver)

    driver.controllers[0].push("HOME", ms_after=1000)

    # 設定ボタンを押す
    _scene.select_system_applet("main_setting")

    # みまもり設定 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("みまもり設定")

    _scene = TAuth(driver)

    # この本体で設定 を選択
    _scene.select_moon_setting_by_nx()

    # つぎへ を選択
    _scene.select_safe_level("None")

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no74_auth_boot_from_parental_control.png"
    time.sleep(2)
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】簡易認証アプレット へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "簡易認証アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no75_network_app_boot_from_internet_setting(driver):
    # 設定ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # インターネット を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")

    # インターネット設定 を選択
    driver.controllers[0].push("A", ms_after=1000)
    if not _scene.is_transited_to_AP_list():
        mes = "AP検索 が終了しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 整合性確認
    time.sleep(5)
    if _scene.is_available_show_AP_list():
        logger.info("【OK】ネット接続アプレット へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "ネット接続アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)


def no77_auth_boot_from_internet_setting(driver):
    # みまもり設定の有無を確認
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        # みまもり登録する
        register_moon_setting(driver, "None")

    # 設定ボタン を押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # インターネット を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")

    # 登録済み AP を選択
    driver.controllers[0].push("A", ms_after=1000)
    if _scene.is_transited_to_AP_list():
        time.sleep(5)
        if _scene.is_available_show_AP_list():
            driver.controllers[0].push("A", ms_after=1000)
        else:
            mes = "AP一覧へ遷移できませんでした。"
            logger.info("【NG】{0}".format(mes))
            return make_result_list("NG", message=mes)
    else:
        mes = "AP検索 が終了しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 解除する を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(2)
    result = []
    image = (_ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png")
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】簡易認証アプレット へ遷移しました。")
        result = make_result_list("OK")
    else:
        mes = "簡易認証アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # みまもり解除
    driver.controllers[0].push("HOME", ms_after=1000)
    delete_moon_setting(driver)

    return result

def no78_web_app_boot_from_parental_control(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # みまもり設定 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("みまもり設定")

    # 『Nintendo みまもり Switch』紹介映像を見る を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認( WebApp起動しているかのみの確認: Mcat HAC統合板 2017/07/18 0002～0004 )
    _scene = TCruiser(driver)
    if _scene.is_available_movie_player():
        logger.info("【OK】Webアプレット(動画) へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "Webアプレット(動画) へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no79_data_erase_boot_from_main_setting(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # データ管理 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("データ管理")

    # まとめてデータを整理 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no79_data_erase_boot_from_main_setting.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】データ削除アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    mes = "データ削除アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no80_auth_boot_from_delete_save_data(driver):
    # みまもり設定の有無を確認
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        # みまもり設定を登録する
        register_moon_setting(driver, "None")

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # データ管理 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("データ管理")

    # 大切なデータの管理 を選択
    driver.controllers[0].push("DOWN", ms_press=1500, ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # セーブデータの消去 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(2)
    result = []
    image = _ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】簡易認証アプレット へ遷移しました。")
        result = make_result_list("OK")
    else:
        mes = "簡易認証アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # みまもり設定を解除する
    driver.controllers[0].push("HOME", ms_after=1000)
    delete_moon_setting(driver)

    return result

def no81_auth_boot_from_delete_ss_all_NAND(driver):
    # みまもり設定の有無を確認
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        # みまもり設定を登録する
        register_moon_setting(driver, "None")

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # データ管理 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("データ管理")

    # 大切なデータの管理 を選択
    for i in range(2):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 画面写真の管理 を選択
    driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 本体保存メモリー を選択
    driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 本体保存メモリー内の画面写真をすべて消去 を選択
    driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(2)
    result = []
    image = _ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】簡易認証アプレット へ遷移しました。")
        result = make_result_list("OK")
    else:
        mes = "簡易認証アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # みまもり設定を解除する
    driver.controllers[0].push("HOME", ms_after=1000)
    delete_moon_setting(driver)

    return result

def no82_auth_boot_from_delete_ss_all_SD(driver):
    # みまもり設定の有無を確認
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        # みまもり設定を登録する
        register_moon_setting(driver, "None")

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # データ管理 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("データ管理")

    # 大切なデータの管理 を選択
    for i in range(2):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 画面写真の管理 を選択
    driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # SDカード を選択
    for i in range(2):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # SDカード内の画面写真をすべて消去 を選択
    driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(2)
    result = []
    image = _ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】簡易認証アプレット へ遷移しました。")
        result = make_result_list("OK")
    else:
        mes = "簡易認証アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # みまもり設定を解除する
    driver.controllers[0].push("HOME", ms_after=1000)
    delete_moon_setting(driver)

    return result

def no83_scoop_viewer_boot_from_main_setting(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # データ管理 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("データ管理")

    # 大切なデータの管理 を選択
    for i in range(2):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 画面写真の管理 を選択
    driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # ひとつずつ整理 を選択
    for i in range(3):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(2)
    _scene = TAlbum(driver)
    if _scene.is_available():
        logger.info("【OK】アルバム へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アルバム へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no84_swkbd_boot_from_users(driver):
    # 設定 ボタンを選択
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # ユーザーアイコン を選択
    driver.controllers[0].push("A", ms_after=1000)

    # ニックネーム を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TSwkbd(driver)
    if _scene.is_available():
        logger.info("【OK】SWKBD へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "SWKBD へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no85_login_app_boot_from_users(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # UA のユーザーアイコンを選択
    driver.controllers[0].push("RIGHT", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # ニンテンドーアカウントと連携 を選択
    for i in range(2):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    time.sleep(2)
    image = _ICON_IMAGE_PATH + "NA_guide_header.png"
    if driver.screen.detect_object_with_image(image) is not None:
        logger.info("【OK】ログインアプレット へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "ログインアプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no86_swkbd_boot_from_add_user(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # あたらしいユーザーの追加を選択
    if not _scene.select_user_menu("あたらしいユーザーの追加"):
        mes = "あたらしいユーザーの追加画面へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # つぎへ を選択
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    # 任意のアイコン( Mii以外 )を選択
    time.sleep(1)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TSwkbd(driver)
    if _scene.is_available():
        logger.info("【OK】SWKBD へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "SWKBD へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no87_swkbd_boot_from_mii_edit(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # あたらしいユーザーの追加 を選択
    if not _scene.select_user_menu("あたらしいユーザーの追加"):
        mes = "あたらしいユーザーの追加画面へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # つぎへ を選択
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    # Miiアイコンを選択
    time.sleep(1)
    driver.controllers[0].push("RIGHT", ms_press=2000, ms_after=1000)
    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # Miiスタジオアプレット 起動
    _scene = TMiiEdit(driver)
    if not _scene.is_available():
        mes = "MiiEditN へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))

    # ニックネーム入力シーンへ進む
    driver.controllers[0].push("A", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)
    for i in range(6):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TSwkbd(driver)
    if _scene.is_available():
        logger.info("【OK】SWKBD へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "SWKBD へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no88_mii_edit_boot_from_add_user(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # あたらしいユーザーの追加 を選択
    if not _scene.select_user_menu("あたらしいユーザーの追加"):
        mes = "あたらしいユーザーの追加画面へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # つぎへ を選択
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    # Mii アイコン選択
    driver.controllers[0].push("RIGHT", ms_press=2000, ms_after=1000)
    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TMiiEdit(driver)
    if _scene.is_available():
        logger.info("【OK】MiiEditN へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "MiiEditN へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no89_cabinet_boot_from_add_user(driver):
    # 右Joy-Con との接続を復活させる
    if detect_invalid_ukyou_in_find_disconnect_controller(driver):
        driver.controllers[0].push("A", ms_after=1000)
        driver.controllers[0].push("HOME", ms_after=1000)
        time.sleep(2)
    else:
        mes = "検証に使用する右Joy-Conの接続に失敗しました。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # あたらしいユーザーの追加 を選択
    if not _scene.select_user_menu("あたらしいユーザーの追加"):
        mes = "あたらしいユーザーの追加画面へ遷移できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # つぎへ を選択
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    # Mii アイコンを選択
    driver.controllers[0].push("RIGHT", ms_press=2000, ms_after=1000)
    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # Miiスタジオアプレットが起動する
    _scene = TMiiEdit(driver)
    if not _scene.is_available():
        mes = "MiiEditN へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # amiiboからMiiをコピー を選択する
    for i in range(2):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "cabinet_top_identity.png"
    for i in range(5):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】amiibo設定アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    mes = "amiibo設定アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no90_auth_boot_from_delete_user(driver):
    # みまもり設定の有無を確認
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        # みまもり設定を登録する
        register_moon_setting(driver, "None")

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # 任意のユーザーアイコンを選択
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ユーザーの消去を選択
    driver.controllers[0].push("DOWN", ms_press=2000, ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    result = []
    image = _ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png"
    for i in range(5):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】簡易認証アプレット へ遷移しました。")
            result = make_result_list("OK")
            break
        else:
            time.sleep(1)
    else:
        mes = "簡易認証アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # みまもり設定を解除する
    driver.controllers[0].push("HOME", ms_after=1000)
    delete_moon_setting(driver)

    return result

def no91_block_list_from_users(driver):
    # NA連携有無の確認、なければ連携する
    if not is_NA_linked_user_seq(driver):
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        if not link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True):
            mes = "NA連携に失敗しました。"
            logger.info("【NG】{0}".format(mes))
            return make_result_list("NG", message=mes)

    driver.controllers[0].push("HOME", ms_after=1000)
    time.sleep(2)

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # NA に紐付いたユーザーを選択
    driver.controllers[0].push("A", ms_after=1000)

    # ブロックリスト管理 を選択
    for i in range(3):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TMypage(driver)
    if _scene.is_available_block_list():
        logger.info("【OK】ブロックリスト へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "ブロックリスト へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no92_block_list_from_mypage(driver):
    # NA連携有無の確認、なければ連携する
    if not is_NA_linked_user_seq(driver):
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        if not link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True):
            mes = "NA連携に失敗しました。"
            logger.info("【NG】{0}".format(mes))
            return make_result_list("NG", message=mes)

    driver.controllers[0].push("HOME", ms_after=1000)
    time.sleep(2)

    # NA の紐付いたユーザーアイコンを選択
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ユーザー設定 を選択
    _scene = TMypage(driver)
    if not _scene.is_available():
        mes = "マイページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)
    _scene.select_navi_bar("ユーザー設定")

    # ブロックリスト管理 を選択
    for i in range(3):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A")

    # 整合性確認
    if _scene.is_available_block_list():
        logger.info("【OK】ブロックリスト へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "ブロックリスト へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no93_sns_setting_from_users(driver):
    # NA連携有無の確認、なければ連携する
    if not is_NA_linked_user_seq(driver):
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        if not link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True):
            mes = "NA連携に失敗しました。"
            logger.info("【NG】{0}".format(mes))
            return make_result_list("NG", message=mes)

    driver.controllers[0].push("HOME", ms_after=1000)
    time.sleep(2)

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # NA を選択
    driver.controllers[0].push("A", ms_after=1000)

    # SNSへの投稿設定 を選択
    _scene = UserSetting(driver)
    _scene.select_button("SNSへの投稿設定")

    # 整合性確認
    id_img = _ICON_IMAGE_PATH + "sns_setting_identity.png"
    for j in range(30):
        if driver.screen.detect_object_with_image(id_img) is not None:
            logger.info("【OK】SNSへの投稿設定 へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    else:
        mes = "SNSへの投稿設定 へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no94_shop_setting_from_users(driver):
    # NA連携有無の確認、なければ連携する
    if not is_NA_linked_user_seq(driver):
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        if not link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True):
            mes = "NA連携に失敗しました。"
            logger.info("【NG】{0}".format(mes))
            return make_result_list("NG", message=mes)

    driver.controllers[0].push("HOME", ms_after=1000)
    time.sleep(2)

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # NAに紐付いたユーザーを選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")
    driver.controllers[0].push("A", ms_after=1000)

    # ニンテンドーeショップの設定 を選択
    _scene = UserSetting(driver)
    _scene.select_button("ニンテンドーeショップの設定")

    # 各種認証を通過する
    # ショップログイン済みのユーザー：アカウント情報画面へ遷移
    # ショップログインがまだのユーザー：ショップ機器認証→Web認証→パスワード再入力→アカウント情報画面
    acc_info_img = _ICON_IMAGE_PATH + "shop_mypage_account_info.png"
    shop_auth_img = RES_PATH + "/eshop/shop_authentication_identity.png"

    _scene = ShopN(driver)
    for i in range(60):
        if driver.screen.detect_object_with_image(acc_info_img) is not None:
            break
        elif driver.screen.detect_object_with_image(shop_auth_img) is not None:
            _scene.pass_shop_authentication()
            time.sleep(7)
            if driver.screen.detect_object_with_image(acc_info_img) is not None:
                break
            else:
                mes = "ショップ機器認証後、アカウント情報画面へ遷移しませんでした。"
                logger.info("【NG】{0}".format(mes))
                return make_result_list("NG", message=mes)
    else:
        mes = "想定と異なる画面へ遷移している可能性があります。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    logger.info("【OK】アカウント情報画面 へ遷移しました。")
    return make_result_list("OK")


def no95_mii_edit_boot_from_main_setting(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # Mii を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("Mii")

    # Miiの作成・編集 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TMiiEdit(driver)
    if _scene.is_available():
        logger.info("【OK】MiiEditN へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "MiiEditN へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no96_cabinet_boot_from_main_setting(driver):
    # 右Joy-Con との接続を復活させる
    if detect_invalid_ukyou_in_find_disconnect_controller(driver):
        driver.controllers[0].push("A", ms_after=1000)
        driver.controllers[0].push("HOME", ms_after=1000)
        time.sleep(2)
    else:
        mes = "検証に使用する右Joy-Conの接続に失敗しました。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # amiibo を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("amiibo")

    # 任意の項目を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "cabinet_top_identity.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】amiibo設定アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)
    mes = "amiibo設定アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no97_controller_support_boot_from_main_setting(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # コントローラーとセンサー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("コントローラーとセンサー")

    # コントローラーの持ち方/順番を変える を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TControllerSupport(driver)
    if _scene.is_available_change_grip_and_order():
        logger.info("【OK】コントローラーサポートアプレット へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "コントローラーサポートアプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no98_auth_boot_from_region(driver):
    # みまもり設定を確認、なければONにする
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        logger.info("みまもり設定を登録します。")
        register_moon_setting(driver, "None")

    # 設定 ボタンを押す
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # 地域 を選択
    _scene.select_system_menu("地域")

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】簡易認証アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "簡易認証アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no99_auth_boot_from_date_and_time(driver):
    # みまもり設定を確認、なければONにする
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        logger.info("みまもり設定を登録します。")
        register_moon_setting(driver, "None")

    # 設定 ボタンをおす
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # 日付と時刻 を選択
    _scene.select_system_menu("日付と時刻")

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】簡易認証アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "簡易認証アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no100_auth_boot_from_lower_max_headphone_volume(driver):
    # みまもり設定を確認、ONでなければ登録
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        logger.info("みまもり設定を登録します。")
        register_moon_setting(driver, "None")

    # 設定 ボタンを押す
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # ヘッドホンの最大音量を下げる を選択
    _scene.select_system_menu("ヘッドホンの最大音量を下げる")

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】簡易認証アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "簡易認証アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no101_network_app_boot_from_system_update(driver):
    # ネット接続の有無を確認、あれば登録AP数を0にする
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")
    driver.controllers[0].push("A", ms_after=1000)
    _scene.is_transited_to_AP_list()
    for i in range(32):
        if _scene.check_any_registered_AP():
            break
        else:
            _scene.delete_registered_AP()
    driver.controllers[0].push("HOME", ms_after=1000)

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # 本体の更新 を選択
    _scene.select_system_menu("本体の更新")

    # インターネット設定へ を選択
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    result = []
    image = _ICON_IMAGE_PATH + "search_network_header.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            if _scene.is_transited_to_AP_list():
                logger.info("【OK】ネット接続アプレット へ遷移しました。")
                result = make_result_list("OK")
                break
            else:
                time.sleep(1)
    else:
        mes = "ネット接続アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # AP登録
    _scene.is_transited_to_AP_list()
    togo_register_AP_seq_by_manual_setup(driver)
    return result

def no103_swkbd_boot_from_console_nickname(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # 本体のニックネーム を選択
    _scene.select_system_menu("本体のニックネーム")

    # 整合性確認
    _scene = TSwkbd(driver)
    if _scene.is_available():
        logger.info("【OK】SWKBD へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "SWKBD へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no104_offline_web_app_boot_from_intellectual_property_notices(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # 知的財産の表記 を選択
    _scene.select_system_menu("知的財産の表記")

    # 整合性確認
    image =  _ICON_IMAGE_PATH + "no37_property_from_option.png" 
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】オフラインWebアプレット( 知的財産の表記 ) へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "オフラインWebアプレット( 知的財産の表記 ) へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no105_err_app_eula_from_main_setting(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # 利用規約 を選択
    _scene.select_system_menu("利用規約")

    # 整合性確認
    image =  _ICON_IMAGE_PATH + "eula_identity_JP.png"
    for i in range(20):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】エラービューアアプレット( 利用規約 ) へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "エラービューアアプレット( 利用規約 ) へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no106_login_app_boot_from_news_setting(driver):
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=2000)

    # NA 連携済みユーザーを 0 にする
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = TMypage(driver)
    _scene.is_available()
    if _scene.is_NA_linked_user():
        # NA 連携解除
        driver.controllers[0].push("HOME", ms_after=1000)
        time.sleep(1)

        _scene = THomeMenu(driver)
        _scene.select_system_applet("main_setting")
        _scene = TMainSetting(driver)
        _scene.select_left_menu_by_keys("ユーザー")
        driver.controllers[0].push("A", ms_after=1000)

        if not unlink_NA_seq(driver):
            mes = "テスト環境準備ができませんでした。検証をスキップします。"
            logger.info(mes)
            return make_result_list("NG", message=mes)
    else:
        driver.controllers[0].push("HOME", ms_after=1000)

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # ゲームニュースの設定 を選択
    _scene.select_system_menu("ゲームニュースのチャンネル設定")

    # つぎへ を選択
    time.sleep(1)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    result = []
    image = _ICON_IMAGE_PATH + "no70_psel_boot_from_news_search_channel.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            result = make_result_list("OK")
            break
        else:
            time.sleep(1)
    else:
        mes = "アカウント管理アプレット へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)

    # NA 復帰 ～ ショップログイン
    time.sleep(1)
    driver.controllers[0].push("A", ms_after=1000)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
    time.sleep(1)

    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")
    time.sleep(1)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        time.sleep(1)
        _scene.pass_shop_authentication()

    return result

def no107_auth_boot_from_initialize(driver):
    # みまもり設定の確認。OFF なら登録する。
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        logger.info("みまもり設定を登録します。")
        register_moon_setting(driver, "None")

    # 設定 ボタンを押す
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # 初期化 を選択
    _scene.select_system_menu("初期化")

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no42_auth_boot_from_unlock_btn.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】簡易認証アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "簡易認証アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no108_psel_boot_from_reset_cache(driver):
    # みまもり確認、ON なら 設定を削除する
    _scene = THomeMenu(driver)
    if _scene.check_already_registered_parental_control():
        logger.info("みまもり設定を削除します。")
        delete_moon_setting(driver)

    # 設定 ボタンを押す
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # 初期化 を選択
    _scene.select_system_menu("初期化")

    # キャッシュの初期化 を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no108_no109_psel_title.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "アカウント管理アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no109_psel_boot_from_reset_keyboard(driver):
    # みまもり確認、ON なら 設定を削除する
    _scene = THomeMenu(driver)
    if _scene.check_already_registered_parental_control():
        logger.info("みまもり設定を削除します。")
        delete_moon_setting(driver)

    # 設定 ボタンを押す
    _scene.select_system_applet("main_setting")

    # 本体 を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("本体")

    # 初期化 を選択
    _scene.select_system_menu("初期化")

    # キーボードの初期化 を選択
    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    image = _ICON_IMAGE_PATH + "no108_no109_psel_title.png"
    for i in range(10):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "アカウント管理アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no111_psel_boot_from_users_add_new_user(driver):
    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # あたらしいユーザーの追加 を選択
    for i in range(2):
        driver.controllers[0].push("DOWN", ms_after=500)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = TPsel(driver)
    if _scene.is_available_add_new_user():
        logger.info("【OK】アカウント管理アプレット( ユーザー追加 ) へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウント管理アプレット( ユーザー追加 ) へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no113_psel_boot_from_only_aoc_title(driver):
    # AOCのみ( 0100fad001e95001 / 1BG5A ) DL済みであること
    # AOCアイコンを選択する
    app_icon_img = _ICON_IMAGE_PATH + "only_aoc_app_title_name.png"
    for i in range(11):
        if driver.screen.detect_object_with_image(app_icon_img) is not None:
            driver.controllers[0].push("A", ms_after=1000)
            break
        else:
            driver.controllers[0].push("RIGHT", ms_after=1000)
    else:
        mes = "HOMEメニューに対象のAOCアイコンが発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # ニンテンドーeショップへ を選択
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    result = []
    image = _ICON_IMAGE_PATH + "no39_psel_from_opt_to_shop.png"
    for i in range(5):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】アカウント管理アプレット へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "アカウント管理アプレット へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no114_login_app_boot_from_only_aoc_title(driver):
    # AOCのみ( 0100fad001e95001 / 1BG5A ) DL済みであること
    # AOCアイコンを選択する
    _scene = THomeMenu(driver)
    app_icon_img = _ICON_IMAGE_PATH + "only_aoc_app_title_name.png"
    for i in range(11):
        if driver.screen.detect_object_with_image(app_icon_img) is not None:
            driver.controllers[0].push("A", ms_after=1000)
            break
        else:
            driver.controllers[0].push("RIGHT", ms_after=1000)
    else:
        mes = "HOMEメニューに対象のAOCアイコンが発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # ニンテンドーeショップへ を選択
    driver.controllers[0].push("A", ms_after=1000)

    # UA を選択
    time.sleep(2)
    driver.controllers[0].push("RIGHT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # ログイン を選択
    time.sleep(2)
    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    # web 認証を通過する
    _scene.input_user_authentication()

    # 整合性確認
    _scene = TCruiser(driver)
    if _scene.is_available_NA_login_page():
        logger.info("【OK】アカウントログインページ へ遷移しました。")
        return make_result_list("OK")
    else:
        mes = "アカウントログインページ へ遷移しませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)


def no115_shop_boot_from_only_aoc_title(driver):
    # AOCのみ( 0100fad001e95001 / 1BG5A ) DL済みであること
    # NA 連携を確認。未連携の場合は連携を行う
    if not is_NA_linked_user_seq(driver):
        driver.controllers[0].push("DOWN", ms_after=800)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=500)
        driver.controllers[0].push("A", ms_after=1000)

        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
        time.sleep(2)

    driver.controllers[0].push("HOME", ms_after=1000)
    time.sleep(2)

    # AOCアイコンを選択する
    app_icon_img = _ICON_IMAGE_PATH + "only_aoc_app_title_name.png"
    for i in range(11):
        if driver.screen.detect_object_with_image(app_icon_img) is not None:
            driver.controllers[0].push("A", ms_after=1000)
            break
        else:
            driver.controllers[0].push("RIGHT", ms_after=500)
    else:
        mes = "HOMEメニューに対象のAOCアイコンが確認できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # ニンテンドーeショップへ を選択する
    driver.controllers[0].push("A", ms_after=1000)

    # NA を選択する
    time.sleep(2)
    driver.controllers[0].push("A", ms_after=1000)

    # 整合性確認
    _scene = ShopN(driver)
    if _scene.is_available_shop_authentication():
        _scene.pass_shop_authentication()

    image = _ICON_IMAGE_PATH + "shop_1BG5A_app_info_identity.png"
    for i in range(30):
        if driver.screen.detect_object_with_image(image) is not None:
            logger.info("【OK】ショップ へ遷移しました。")
            return make_result_list("OK")
        else:
            time.sleep(1)

    mes = "ショップ へ遷移しませんでした。"
    logger.info("【NG】{0}".format(mes))
    return make_result_list("NG", message=mes)

def no118_psel_boot_from_application(driver):
    # dummy app( 0100fb5001f0e000 / 1BJ2A ) DL済みであること
    # NA 連携を確認。未連携の場合は連携を行う
    if not is_NA_linked_user_seq(driver):
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=500)
        driver.controllers[0].push("A", ms_after=1000)

        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
        time.sleep(2)

        # ショップ機器認証
        driver.controllers[0].push("HOME", ms_after=1000)
        time.sleep(2)

        _scene = THomeMenu(driver)
        _scene.select_system_applet("eShop")
        time.sleep(2)
        driver.controllers[0].push("A", ms_after=1000)

        _scene = ShopN(driver)
        if _scene.is_available_shop_authentication():
            _scene.pass_shop_authentication()

    driver.controllers[0].push("HOME", ms_after=1000)
    time.sleep(2)

    # ダミーアプリを起動する
    app_icon_img_list = [ _ICON_IMAGE_PATH + "dummy_0100fb5001f0e000_A.png",
                          _ICON_IMAGE_PATH + "dummy_0100fb5001f0e000_B.png" ]
    for i in range(11):
        for img in app_icon_img_list:
            if driver.screen.detect_object_with_image(img, threshold=0.98) is not None:
                driver.controllers[0].push("A", ms_after=1000)

                # 整合性確認
                image =  _ICON_IMAGE_PATH + "no118_psel_boot_from_application.png" 
                for i in range(30):
                    if driver.screen.detect_object_with_image(image) is not None:
                        logger.info("【OK】アカウント管理アプレット へ遷移しました。")
                        return make_result_list("OK")
                    else:
                        time.sleep(1)

                mes = "アカウント管理アプレット へ遷移しませんでした。"
                logger.info("【NG】{0}".format(mes))
                return make_result_list("NG", message=mes)
        else:
            driver.controllers[0].push("RIGHT", ms_after=1000)
    else:
        mes = "起動の対象となるアプリを発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no119_login_app_boot_from_application(driver):
    # dummy app( 0100fb5001f0e000 / 1BJ2A ) DL済みであること
    # NA 連携を確認。未連携の場合は連携を行う
    if not is_NA_linked_user_seq(driver):
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=500)
        driver.controllers[0].push("A", ms_after=1000)

        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
        time.sleep(2)

        # ショップ機器認証
        driver.controllers[0].push("HOME", ms_after=1000)
        time.sleep(2)

        _scene = THomeMenu(driver)
        _scene.select_system_applet("eShop")
        time.sleep(2)
        driver.controllers[0].push("A", ms_after=1000)

        _scene = ShopN(driver)
        if _scene.is_available_shop_authentication():
            _scene.pass_shop_authentication()

    driver.controllers[0].push("HOME", ms_after=1000)
    time.sleep(2)

    # ダミーアプリを起動する
    app_icon_img_list = [ _ICON_IMAGE_PATH + "dummy_0100fb5001f0e000_A.png",
                          _ICON_IMAGE_PATH + "dummy_0100fb5001f0e000_B.png"]
    for i in range(11):
        for img in app_icon_img_list:
            if driver.screen.detect_object_with_image(img, threshold=0.98) is not None:
                driver.controllers[0].push("A", ms_after=1000)

                # +アイコンを選択
                driver.controllers[0].push("RIGHT", ms_press=2000, ms_after=1000)
                driver.controllers[0].push("A", ms_after=1000)

                _scene = TPsel(driver)
                _scene.add_new_user_account()

                # ログイン を選択
                driver.controllers[0].push("UP", ms_after=1000)
                driver.controllers[0].push("A", ms_after=1000)

                # web 認証 を通過する
                _scene.input_user_authentication(save_flg=False)

                # 整合性確認
                _scene = TCruiser(driver)
                if _scene.is_available_NA_login_page():
                    logger.info("【OK】アカウントログインページ へ遷移しました。")
                    return make_result_list("OK")
                else:
                    mes = "アカウントログインページ へ遷移しませんでした。"
                    logger.info("【NG】{0}".format(mes))
                    return make_result_list("NG", message=mes)
        else:
            driver.controllers[0].push("RIGHT", ms_after=1000)
    else:
        mes = "起動の対象となるアプリを発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no120_err_app_boot_from_apps_rating(driver):
    # NA 連携を確認。未連携の場合は連携を行う
    if not is_NA_linked_user_seq(driver):
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=500)
        driver.controllers[0].push("A", ms_after=1000)

        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
        time.sleep(2)

        # ショップ機器認証
        driver.controllers[0].push("HOME", ms_after=1000)
        time.sleep(2)

        _scene = THomeMenu(driver)
        _scene.select_system_applet("eShop")
        time.sleep(2)
        driver.controllers[0].push("A", ms_after=1000)

        _scene = ShopN(driver)
        if _scene.is_available_shop_authentication():
            _scene.pass_shop_authentication()

    driver.controllers[0].push("HOME", ms_after=1000)
    time.sleep(2)

    # みまもり設定の有無確認、OFFなら制限レベル「設定なし」以外でONにする
    _scene = THomeMenu(driver)
    if not _scene.check_already_registered_parental_control():
        register_moon_setting(driver, "Teens")

    # レーティング設定済みのアプリ を起動する
    app_icon_image_list = [ _ICON_IMAGE_PATH + "dummy_01000dd001e70000_A.png",
                            _ICON_IMAGE_PATH + "dummy_01000dd001e70000_B.png" ]
    image = _ICON_IMAGE_PATH + "no120_err_app_boot_from_apps_rating.png"

    for i in range(11):
        for img in app_icon_image_list:
            if driver.screen.detect_object_with_image(img, threshold=0.98) is not None:
                driver.controllers[0].push("A", ms_after=1000)

                # 整合性確認
                time.sleep(1)
                if driver.screen.detect_object_with_image(image) is not None:
                    logger.info("【OK】エラーアプレット へ遷移しました。")
                    return make_result_list("OK")
                else:
                    mes = "エラーアプレット へ遷移しませんでした。"
                    logger.info("【NG】{0}".format(mes))
                    return make_result_list("NG", message=mes)
        else:
            driver.controllers[0].push("RIGHT", ms_after=1000)
    else:
        mes = "起動の対象となるアプリを発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no121_network_app_boot_from_drm_check(driver):
    # NA 連携を確認。未連携の場合は連携を行う
    if not is_NA_linked_user_seq(driver):
        driver.controllers[0].push("DOWN", ms_after=1000)
        driver.controllers[0].push("A", ms_after=1000)
        time.sleep(2)
        driver.controllers[0].push("LEFT", ms_after=500)
        driver.controllers[0].push("A", ms_after=1000)

        link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)
        time.sleep(2)

    driver.controllers[0].push("HOME", ms_after=1000)
    time.sleep(2)

    # 設定 ボタンを押す
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    # ユーザー を選択
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("ユーザー")

    # NA を選択
    driver.controllers[0].push("A", ms_after=1000)

    # NA連携を解除する
    if not unlink_NA_seq(driver):
        mes = "NAの連携解除に失敗しました。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

    # 登録済みAPの数をチェック。1個以上あればAPの削除。
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")
    driver.controllers[0].push("A", ms_after=1000)
    for i in range(32): # 登録済みAPは32個まで記憶される
        if _scene.check_any_registered_AP():
            logger.info("APの登録数が 0件 であることを確認。")
            break
        else:
            _scene.delete_registered_AP()

    driver.controllers[0].push("HOME", ms_after=1000)

    # 既定のアプリを選択する( 権利チェックへ )
    image_path_list = [ _ICON_IMAGE_PATH + "dummy_0100fb5001f0e000_A.png",
                        _ICON_IMAGE_PATH + "dummy_0100fb5001f0e000_B.png" ]

    result = []
    for i in range(11):
        for image in image_path_list:
            if driver.screen.detect_object_with_image(image, threshold=0.98) is not None:
                driver.controllers[0].push("A", ms_after=1000)
                driver.controllers[0].push("A", ms_after=1000)

                # インターネット設定へ を選択
                image2 = _ICON_IMAGE_PATH + "no_net_connect_dialog.png"
                for j in range(60):
                    if driver.screen.detect_object_with_image(image2) is not None:
                        driver.controllers[0].push("A", ms_after=1000)
                        _scene = TMainSetting(driver)
                        _scene.is_available_show_AP_list()

                        # 整合性確認
                        image3 = _ICON_IMAGE_PATH + "search_network_header.png"
                        if driver.screen.detect_object_with_image(image3) is not None:
                            logger.info("【OK】ネット接続アプレット へ遷移しました。")
                            result = make_result_list("OK")
                            time.sleep(2)

                            # AP登録
                            togo_register_AP_seq_by_manual_setup(driver)
                            driver.controllers[0].push("HOME", ms_after=1000)

                            # NA 連携～ショップログイン
                            driver.controllers[0].push("UP", ms_after=1000)
                            driver.controllers[0].push("A")

                            _scene = TMypage(driver)
                            _scene.is_available()
                            _scene.select_navi_bar("プロフィール")
                            driver.controllers[0].push("DOWN", ms_after=1000)
                            driver.controllers[0].push("A", ms_after=1000)

                            time.sleep(2)
                            driver.controllers[0].push("LEFT", ms_after=1000)
                            driver.controllers[0].push("A", ms_after=1000) # login app で ログイン

                            link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)

                            time.sleep(2)
                            _scene = THomeMenu(driver)
                            _scene.select_system_applet("eShop")
                            time.sleep(1)
                            driver.controllers[0].push("A", ms_after=1000)

                            _scene = ShopN(driver)
                            if not _scene.is_available_shop_authentication():
                                logger.info("検証終了後の ショップログインに失敗しています。")

                            _scene.pass_shop_authentication()
                            return result

                else:
                    mes = "ネット接続アプレット へ遷移しませんでした。"
                    logger.info("【NG】{0}".format(mes))
                    return make_result_list("NG", message=mes)

        else:
            driver.controllers[0].push("RIGHT", ms_after=1000)

    else:
        mes = "起動の対象となるアプリを発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        return make_result_list("NG", message=mes)

def no124_err_app_boot_from_drm_check(driver):
    # ネット接続の有無確認、なければAP登録数1 にする
    if check_any_available_network_setting(driver):
        togo_register_AP_seq_by_manual_setup(driver)

    driver.controllers[0].push("HOME", ms_after=2000)

    # NA紐付解除
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = TMypage(driver)
    if _scene.is_NA_linked_user():
        driver.controllers[0].push("HOME", ms_after=1000)
        _scene = THomeMenu(driver)
        _scene.select_system_applet("main_setting")

        _scene = TMainSetting(driver)
        _scene.select_left_menu_by_keys("ユーザー")
        driver.controllers[0].push("A", ms_after=1000)
        unlink_NA_seq(driver)
    driver.controllers[0].push("HOME", ms_after=1000)
    _scene = THomeMenu(driver)

    # AP、誤ったプロキシ設定を保存
    _scene.select_system_applet("main_setting")
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")

    driver.controllers[0].push("A", ms_after=1000)
    _scene.is_available_show_AP_list()
    time.sleep(1)
    driver.controllers[0].push("A", ms_after=1000)
    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    _scene.enable_incorrect_proxy_setting()
    time.sleep(1)
    driver.controllers[0].push("HOME", ms_after=1000)

    # ダミーアプリ起動
    image_list = [ _ICON_IMAGE_PATH + "dummy_0100fb5001f0e000_A.png" ,
                   _ICON_IMAGE_PATH + "dummy_0100fb5001f0e000_B.png" ]
    drm_img = _ICON_IMAGE_PATH + "application_drm_checking.png"
    image = _ICON_IMAGE_PATH + "no124_err_app_boot_from_drm_check.png"
    ic_flg = True
    result = []

    for i in range(11):
        for img in image_list:
            if driver.screen.detect_object_with_image(img, threshold=0.98) is not None:
                driver.controllers[0].push("A", ms_after=1000)
                driver.controllers[0].push("A", ms_after=1000)
                break

        if driver.screen.detect_object_with_image(drm_img) is not None:
            break
        else:
            driver.controllers[0].push("RIGHT", ms_after=1000)
    else:
        mes = "起動の対象となったアプリが発見できませんでした。"
        logger.info("【NG】{0}".format(mes))
        result = make_result_list("NG", message=mes)
        ic_flg = False

    # 整合性確認
    if ic_flg:
        for i in range(60):
            if driver.screen.detect_object_with_image(image) is not None:
                logger.info("【OK】エラービューアアプレット へ遷移しました。")
                result = make_result_list("OK")
                break
            else:
                time.sleep(1)
        else:
            mes = "エラービューアアプレット へ遷移しませんでした。"
            logger.info("【NG】{0}".format(mes))
            result = make_result_list("NG", message=mes)

    # AP、プロキシ設定を直す
    driver.controllers[0].push("HOME", ms_after=1000)
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")
    time.sleep(1)
    driver.controllers[0].push("A", ms_after=1000)
    _scene.is_available_show_AP_list()
    time.sleep(1)
    driver.controllers[0].push("A", ms_after=2000)
    driver.controllers[0].push("DOWN", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    _scene.disable_incorrect_proxy_setting()

    driver.controllers[0].push("HOME", ms_after=1000)

    # NAの再紐付
    driver.controllers[0].push("UP", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = TMypage(driver)
    _scene.select_navi_bar("フレンドになれるかも？")
    driver.controllers[0].push("A", ms_after=2000)

    driver.controllers[0].push("LEFT", ms_after=1000)
    driver.controllers[0].push("A", ms_after=1000)

    link_NA_seq(driver, _na_login_id, "", save_basic_auth_flg=True)

    # ショップログイン
    time.sleep(2)
    _scene = THomeMenu(driver)
    _scene.select_system_applet("eShop")
    time.sleep(1)
    driver.controllers[0].push("A", ms_after=1000)

    _scene = ShopN(driver)
    _scene.is_available_shop_authentication()
    _scene.pass_shop_authentication()

    return result

if __name__ == "__main__":
    logger.info("program start")
    logger.info("============================================")

    # params.json 入力チェック
    print(CONF.SSID, CONF.SECURITY_TYPE, CONF.PASSWORD)
    if CONF.SSID == "dummy" or CONF.SECURITY_TYPE == "dummy" or CONF.PASSWORD == "dummy" :
        logger.info("params.json で SSID / security_type / password のいずれかが未入力になっています。")
        logger.info("検証で使用する AP の情報として SSID / セキュリティー / パスワード の入力は必須です。")
    else:
        logger.info("使用するAP情報：SSID = {0}, セキュリティー = {1}, パスワード = {2}"\
                    .format(CONF.SSID, CONF.SECURITY_TYPE, CONF.PASSWORD))

        with factory(target_serial=None,capture_device_id=None, capture_mode=CaptureMode.CaptureMode_720p, is_preview=True, is_open_logreader=False) as _driver:
            t_list = get_execute_test_suites_list()
            _na_login_id = "hoge"
            _driver.controllers.add(0)
            now = datetime.datetime.now()
            columns = ["No", "結果", "日時", "備考"]

            csv_file = r"log\result_{0}_{1}.csv" \
                    .format(now.strftime("%Y%m%d"), now.strftime("%H%M%S"))
    
            _df = Csv_Output(columns, csv_file)
            _df.get_save_path()
    
            result = []
    
            for test_suite in t_list:
                if( test_suite[0] in [
                    # AP接続が必要
                    "17", "18", "19", "20","21","25","31","32","38","40","49",
                    "50", "51", "52", "53","56","57","58","60","61","64",
                    "65","70","71","78","91","92","93","94","101","106","114","115",
                    "118","119","120","121","124",
    
                    # 特殊な環境が必要
                    "35","36","37","16","89","96",
                    "33","81","82","90", "41",
                    
                    # アカウントが複数必要
                    "108","109",

                    # AOC が必要
                    "113",
                    ] ):
                    continue
    
                if test_suite[1] == "FALSE":
                    continue
                elif test_suite[1] == "TRUE":
                    func_info = get_execute_test_suite_info(test_suite[0])
                    logger.info("No.{0} の実行前の準備を開始します。".format(test_suite[0]))
                    result = [test_suite[0]]
                    _scene = THomeMenu(_driver)
    
                    if _scene.check_already_registered_parental_control():
                        delete_moon_setting(_driver)
    
                    if func_info[1] and not _scene.is_connected_AP_from_system_infomation():
                        logger.info("APとの疎通を行います。")
                        enable_to_registered_AP_connection(_driver)
    
                    logger.info("No.{0} の実行を開始します。".format(test_suite[0]))
                    initialize_cursor_position_in_HOME_menu(_driver)
                    result += func_info[0](_driver) # 結果と備考を受け取る。
    
                    _df.add_data(result)
                    _df.write_csv()
    
                    logger.info("no.{0} の実行を終了しました。本体を再起動します。".format(test_suite[0]))
                    reboot_by_control_target()
                    _driver.controllers[0].push("HOME", ms_after=3000)
