# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

import time

from res.res_path import RES_PATH
from scenes.common.t_swkbd import TSwkbd
from scenes.home_menu.t_home_menu import THomeMenu
from scenes.main_setting.t_main_setting import TMainSetting
from sequences.SwkbdInputter import SwkbdInputter
from config.confmgr import CONF


_ICON_IMAGE_PATH = RES_PATH + "/togo_test_cases/"

def togo_register_AP_seq_by_manual_setup(driver, id=0):
    # インターネット設定、AP一覧に遷移した後に呼ぶ。
    # 社内AP全ステルス化に伴い、手動で設定 から APを登録する手順のもの。

    # 入力に使用する情報は params.json から CONF.SSID / CONF.SECURITY_TYPE / CONF.PASSWORD として取得する
    sec_type_dict = { "None": 0,
                      "WEP(Open)": 1,
                      "WEP(Shared)": 2,
                      "WPA-PSK(AES)": 3,
                      "WPA2-PSK(AES)": 4 }

    for i in range(3):
        # 「手動で設定」を選択
        driver.controllers[id].push("DOWN", ms_press=2000, ms_after=500)
        driver.controllers[id].push("A", ms_after=1000)

        # みまもり設定 ON 対応入れるならココ

        # SSID
        driver.controllers[id].push("DOWN", ms_after=500)
        driver.controllers[id].push("A", ms_after=1000)
        _si = SwkbdInputter(driver, strings=CONF.SSID)
        _si.run()

        # security_type / password
        driver.controllers[id].push("DOWN", ms_after=500)
        driver.controllers[id].push("A", ms_after=1000)
        for i in range(sec_type_dict[CONF.SECURITY_TYPE]):
            driver.controllers[id].push("DOWN", ms_after=500)
        driver.controllers[id].push("A", ms_after=1000)
        if CONF.SECURITY_TYPE != "None":
            _si = SwkbdInputter(driver, strings=CONF.PASSWORD)
            _si.run()

        # 保存する
        driver.controllers[id].push("RIGHT", ms_after=500)
        driver.controllers[id].push("A", ms_after=1000)
        driver.controllers[id].push("A", ms_after=1000)

        # 疎通確認
        time.sleep(1)
        driver.controllers[id].push("A", ms_after=1000)
        _scene = TMainSetting(driver)
        if _scene.check_connect_network():
            time.sleep(1)
            return True
        else:
            time.sleep(1)
            print("AP登録失敗")
            driver.controllers[id].push("A", ms_after=3000)
            driver.controllers[id].push("A", ms_after=3000)
            driver.controllers[id].push("B", ms_after=1000)
            if _scene.is_transited_to_AP_list():
                time.sleep(3)
            else:
                return False



def check_any_available_network_setting(driver, id=0):
    # ネット接続の有無確認、なければAP登録数1にする
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")
    driver.controllers[id].push("A", ms_after=1000)

    _scene.is_transited_to_AP_list()
    if _scene.check_any_registered_AP():
        return True
    else:
        return False

def enable_to_registered_AP_connection(driver, id=0):
    # 登録済みAP に接続する( 自動接続してくれない対応 )
    # インターネットへ遷移
    _pc_flg = False
    _scene = THomeMenu(driver)
    if _scene.check_already_registered_parental_control():
        # みまもり有
        _pc_flg = True

    _scene.select_system_applet("main_setting")
    time.sleep(1)
    _scene = TMainSetting(driver)
    _scene.select_left_menu_by_keys("インターネット")

    # インターネット設定を選択
    driver.controllers[id].push("A", ms_after=1000)

    for i in range(5):
        if not _scene.check_any_registered_AP():
            driver.controllers[id].push("A", ms_after=1000)
            if _pc_flg:
                # みまもり一時解除
                driver.controllers[id].push("A", ms_after=1000)
                time.sleep(2)
                for i in range(4):
                    driver.controllers[id].push("A", ms_after=500)
                time.sleep(1)
                _pc_flg = False
                driver.controllers[id].push("A", ms_after=1000)
                if not _scene.check_any_registered_AP():
                    driver.controllers[id].push("A", ms_after=1000)

            driver.controllers[id].push("A", ms_after=1000)
            if _scene.check_connect_network():
                time.sleep(1)
                driver.controllers[id].push("HOME", ms_after=1000)
                return
            else:
                time.sleep(1)
                driver.controllers[id].push("A", ms_after=2000)
                driver.controllers[id].push("A", ms_after=2000)
                driver.controllers[id].push("B", ms_after=1000)

        else:
            # 登録済みAPが0個 => 登録操作1回やって終わっとくくらいで良いと思う。
            togo_register_AP_seq_by_manual_setup(driver)
            break

    driver.controllers[id].push("HOME", ms_after=1000)