# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

import time

from scenes.common.t_auth import TAuth
from scenes.home_menu.t_home_menu import THomeMenu
from scenes.main_setting.t_main_setting import TMainSetting
from kiki.util.log import file_logger as logger


def register_moon_setting(driver, level, id=0):
    # みまもり設定を登録する
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    time.sleep(2)
    _scene = TMainSetting(driver)
    if not _scene.is_available():
        logger.info("みまもり設定のための 本体設定 への遷移ができませんでした。")
        return

    _scene.select_left_menu_by_keys("みまもり設定")
    _scene = TAuth(driver)
    _scene.select_moon_setting_by_nx()
    _scene.select_safe_level(level)

    # PINコード設定
    time.sleep(2)
    for i in range(4):
        driver.controllers[id].push("A", ms_after=500)
    driver.controllers[id].push("START", ms_after=1000)

    # confirm PIN
    for i in range(4):
        driver.controllers[id].push("A", ms_after=500)

    if not _scene.is_registered_moon_setting():
        logger.info("みまもり設定の準備に失敗しました。")
        return
    else:
        driver.controllers[id].push("HOME", ms_after=1000)

def delete_moon_setting(driver, id=0):
    # みまもり設定を削除する
    _scene = THomeMenu(driver)
    _scene.select_system_applet("main_setting")

    time.sleep(3)
    _scene = TMainSetting(driver)
    if not _scene.is_available():
        logger.info("みまもり設定のための 本体設定 への遷移ができませんでした。")
        return

    _scene.select_left_menu_by_keys("みまもり設定")
    _scene = TAuth(driver)
    driver.controllers[id].push("DOWN", ms_after=1000)
    driver.controllers[id].push("A", ms_after=1000)

    time.sleep(1)
    for i in range(4):
        driver.controllers[id].push("A", ms_after=500)

    time.sleep(1)
    driver.controllers[id].push("X", ms_after=1000)
    driver.controllers[id].push("A", ms_after=1000)

    if not _scene.is_deleted_moon_setting():
        logger.info("みまもり設定 の削除に失敗しました。")
        return
    else:
        driver.controllers[id].push("HOME", ms_after=1000)
