# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from abc import ABCMeta, abstractmethod

from kiki.util.log import file_logger as logger

class BaseCommand(object):
    __metaclass__ = ABCMeta

    def __init__(self, hac_driver):
        self.driver = hac_driver

    def run(self):
        logger.info("will execute! [{0}]".format(self.__class__.__name__))
        self.execute()
        logger.info("done!         [{0}]".format(self.__class__.__name__))

    @abstractmethod
    def execute(self):
        pass