# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from kiki.util.log import file_logger as logger
from sequences.base_command import BaseCommand
from scenes.common.swkbd_ascii import SwkbdAscii
from res.swkbd.chara_pos_dictionary import *
import time

class SwkbdInputter(BaseCommand):
    def __init__(self, driver, controller_num=0, strings=None):
        super(SwkbdInputter,self).__init__(driver)
        self.controller_num = controller_num
        self.strings = strings
        self.swkbd =  SwkbdAscii(driver)
        self.chara_pos = ascii_chara_pos
        self.cur_inputmode = CharacterType.AsciiAlphabet
        self.cursor_pos = (0,0)

    def move_cursor(self, c_pos, o_pos):
        diff = (o_pos[0] - c_pos[0], o_pos[1] - c_pos[1])
        if c_pos[1] < 4:
            for i in range(int(abs(diff[0]))):
                if diff[0] < 0 :
                    self.driver.controllers[0].push("LEFT",ms_after=200)
                else:
                    self.driver.controllers[0].push("RIGHT", ms_after=200)

            for i in range(int(abs(diff[1]))):
                if diff[1] < 0 :
                    self.driver.controllers[0].push("UP",ms_after=200)
                else:
                    self.driver.controllers[0].push("DOWN", ms_after=200)
        else:
            for i in range(int(abs(diff[1]))):
                if diff[1] < 0 :
                    self.driver.controllers[0].push("UP",ms_after=200)
                else:
                    self.driver.controllers[0].push("DOWN", ms_after=200)

            for i in range(int(abs(diff[0]))):
                if diff[0] < 0 :
                    self.driver.controllers[0].push("LEFT",ms_after=200)
                else:
                    self.driver.controllers[0].push("RIGHT", ms_after=200)

        self.cursor_pos = o_pos

    def switch_input_mode(self):
        self.move_cursor(self.cursor_pos,(2,4))
        self.driver.controllers[0].push("A", ms_after=500)

    def press_enter_key(self):
        while self.swkbd.is_available():
            self.driver.controllers[0].push("START", ms_after=1000)

    def input_str(self):
        for i in range(20):
            if self.swkbd.is_available():
                break
            else:
                time.sleep(1)

        for chara in self.strings:  # 入力したい文字列をstrで受け取り1文字ずつタッチ入力

            if self.chara_pos[chara][2] is not self.cur_inputmode:
                self.cur_inputmode = self.chara_pos[chara][2]
                self.switch_input_mode()

            pos_x = self.chara_pos[chara][0] / 100 - 1
            pos_y = (self.chara_pos[chara][1]-360) / 65
            pos = (pos_x, pos_y)
            self.move_cursor(self.cursor_pos,pos)

            if self.chara_pos[chara][3] is True:
                self.driver.controllers[0].push("STICK_L", ms_after=200)

            self.driver.controllers[0].push("A", ms_after=500)
        self.driver.controllers[0].push("START", ms_after=1000)


    def execute(self):
        time.sleep(1)
        self.input_str()
        pass
