# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from testcases.examples.utility import touch_bar_point_percent_of

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH

_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"

class MiiNoseEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiNoseEditor, self).__init__(driver)

    def is_available(self):
        return True

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def select_nose_parts(self,id):
        id_pos = {
            0:[130,300],
            1:[230,300],
            2:[330,300],
            3:[430,300],
            4:[530,300],
            5:[630,300],
            6:[130,400],
            7:[230,400],
            8:[330,400],
            9:[430,400],
            10:[530,400],
            11:[630,400],
            12:[130,500],
            13:[230,500],
            14:[330,500],
            15:[430,500],
            16:[530,500],
            17:[630,500],
        }
        self.driver.screen.touch(0,x= 270,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)

    def select_nose_placement(self,nose_placement):
        # 鼻の配置の設定値を上から順にリストでもらい、該当する引数のレベル（パーセンテージ）の位置をタッチする
        #percentage = argument / argument_num
        #touch_bar_point_percent_of(self.driver,start_x=252,start_y=215,angle=0,bar_length=256,percentage=percentage)
        self.driver.screen.touch(0,x= 490,y= 85, ms_after=500)

        arg = nose_placement
        max_arg = [18,8]
        percentages =[]
        for n in range(len(arg)):
            if arg[n] is not None :
                percentages.append(arg[n]/max_arg[n])
            else:
                percentages.append(arg[n])

        bar_y_pos =300
        for x in percentages:
            if x is not None:
                touch_bar_point_percent_of(self.driver,start_x=252,start_y=bar_y_pos,angle=0,bar_length=256,percentage=x)
            bar_y_pos += 80

    def set_nose_settings(self,nose_parts_id,nose_pos,nose_size):
        nose_placement = [nose_pos,nose_size]
        if nose_parts_id is not None:self.select_nose_parts(nose_parts_id)
        self.select_nose_placement(nose_placement)
        self.back_to_edit_menu()

