# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from testcases.examples.utility import touch_bar_point_percent_of

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH

_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"

class MiiFavoriteColorEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiFavoriteColorEditor, self).__init__(driver)

    def select_favorite_color(self,id):
        # 眉毛のパーツidに対する座標をタッチする　"id":[x_pos,y_pos]
        id_pos = {
            0:[180,330],
            1:[260,330],
            2:[340,330],
            3:[420,330],
            4:[500,330],
            5:[580,330],
            6:[180,410],
            7:[260,410],
            8:[340,410],
            9:[420,410],
            10:[500,410],
            11:[580,410],
        }

        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)

    def set_favoritecolor_settings(self,favoritecolor_id):
        if favoritecolor_id is not None :self.select_favorite_color(favoritecolor_id)
        self.back_to_edit_menu()
