# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from testcases.examples.utility import touch_bar_point_percent_of

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH

_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"

class MiiEyebrowsEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiEyebrowsEditor, self).__init__(driver)

    def select_eyebrows_parts(self,id):
        # 眉毛のパーツidに対する座標をタッチする　"id":[x_pos,y_pos]
        id_pos = {
            0:[125,255],
            1:[225,255],
            2:[325,255],
            3:[425,255],
            4:[525,255],
            5:[625,255],
            6:[125,355],
            7:[225,355],
            8:[325,355],
            9:[425,355],
            10:[525,355],
            11:[625,355],
            12:[125,455],
            13:[225,455],
            14:[325,455],
            15:[425,455],
            16:[525,455],
            17:[625,455],
            18:[125,555],
            19:[225,555],
            20:[325,555],
            21:[425,555],
            22:[525,555],
            23:[625,555]
        }
        self.driver.screen.touch(0,x= 210,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)

    def select_eyebrows_placement(self,placement_info):
        # 眉毛の配置の設定値を上から順にリストでもらい、該当する引数のレベルの位置をタッチする
        #percentage = argument / argument_num
        #touch_bar_point_percent_of(self.driver,start_x=252,start_y=215,angle=0,bar_length=256,percentage=percentage)
        self.driver.screen.touch(0,x= 380,y= 85, ms_after=500)

        arg = placement_info
        max_arg = [15,12,11,8,6]
        percentages = []
        for n in range(len(arg)):
            if arg[n] is not None :
                percentages.append(arg[n] / max_arg[n])
            else:
                percentages.append(arg[n])

        bar_y_pos =190
        for x in percentages:
            if x is not None:
                touch_bar_point_percent_of(self.driver,start_x=252,start_y=bar_y_pos,angle=0,bar_length=256,percentage=x)
            bar_y_pos += 80


    def set_eyebrows_settings(self,eyebrows_parts_id,eyebrows_pos,eyebrows_width,eyebrows_incline,eyebrows_size,eyebrows_height,eyebrows_color_id):
        eyebrows_placement = [eyebrows_pos,eyebrows_width,eyebrows_incline,eyebrows_size,eyebrows_height]
        if eyebrows_parts_id is not None: self.select_eyebrows_parts(eyebrows_parts_id)
        if eyebrows_parts_id == 23:
            self.back_to_edit_menu()
        else:
            self.select_eyebrows_placement(eyebrows_placement)
            if eyebrows_color_id is not None:self.select_color_of_parts(eyebrows_color_id)
            self.back_to_edit_menu()

