# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


from params.winpos import WIN_POS
from scenes.base_scene import BaseScene
from testcases.examples.utility import touch_bar_point_percent_of

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH


_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"

class MiiEditor(BaseScene):
    def __init__(self, driver):
        super(MiiEditor, self).__init__(driver)

    def is_available(self):
            return True

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def  select_color_of_parts(self,id):
        # 受け取ったidに対するひげのカラーid をタッチする
        id_pos ={
            0:[125,80],
            1:[181,80],
            2:[237,80],
            3:[294,80],
            4:[351,80],
            5:[408,80],
            6:[465,80],
            7:[522,80],
            8:[579,80],
            9:[636,80],
            10:[123,137],
            11:[180,137],
            12:[237,137],
            13:[294,137],
            14:[351,137],
            15:[408,137],
            16:[465,137],
            17:[522,137],
            18:[579,137],
            19:[636,137],
            20:[123,194],
            21:[180,194],
            22:[237,194],
            23:[294,194],
            24:[351,194],
            25:[408,194],
            26:[465,194],
            27:[522,194],
            28:[579,194],
            29:[636,194],
            30:[123,251],
            31:[180,251],
            32:[237,251],
            33:[294,251],
            34:[351,251],
            35:[408,251],
            36:[465,251],
            37:[522,251],
            38:[579,251],
            39:[636,251],
            40:[123,308],
            41:[180,308],
            42:[237,308],
            43:[294,308],
            44:[351,308],
            45:[408,308],
            46:[465,308],
            47:[522,308],
            48:[579,308],
            49:[636,308],
            50:[123,365],
            51:[180,365],
            52:[237,365],
            53:[294,365],
            54:[351,365],
            55:[408,365],
            56:[465,365],
            57:[522,365],
            58:[579,365],
            59:[636,365],
            60:[123,422],
            61:[180,422],
            62:[237,422],
            63:[294,422],
            64:[351,422],
            65:[408,422],
            66:[465,422],
            67:[522,422],
            68:[579,422],
            69:[636,422],
            70:[123,479],
            71:[180,479],
            72:[237,479],
            73:[294,479],
            74:[351,479],
            75:[408,479],
            76:[465,479],
            77:[522,479],
            78:[579,479],
            79:[636,479],
            80:[123,536],
            81:[180,536],
            82:[237,536],
            83:[294,536],
            84:[351,536],
            85:[408,536],
            86:[465,536],
            87:[522,536],
            88:[579,536],
            89:[636,536],
            90:[123,593],
            91:[180,593],
            92:[237,593],
            93:[294,593],
            94:[351,593],
            95:[408,593],
            96:[465,593],
            97:[522,593],
            98:[579,593],
            99:[636,593],
        }
        self.driver.screen.touch(0,x= 540,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= 365,y= 470, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)

    def back_to_edit_menu(self):

        for x in range(3):

            image = [_ICON_IMAGE_PATH + "mii_editor_menu_icon_01.PNG"]
            result_pos = self._search_icon_from_image_list(icon_image_list=image, threshold=0.33, shows_result=False)
            if result_pos is not None:
                print(result_pos)
                break

            else:
                logger.debug(u"mii_editor トップのアイコンが見つかりませんでした")
                logger.debug(u"もどるを押して前の階層にもどります")
                self.driver.screen.touch(0,x=1025,y=680, ms_after=1000)
                #self.driver.controllers[0].push("B", ms_after=1000)



