# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from res.res_path import RES_PATH

from scenes.base_scene import BaseScene
from scenes.setting_mii.mii_face_editor import MiiFaceEditor
from scenes.setting_mii.mii_eyebrows_editor import MiiEyebrowsEditor
from scenes.setting_mii.mii_nose_editor import MiiNoseEditor
from scenes.setting_mii.mii_mustache_editor import MiiMustacheEditor
from scenes.setting_mii.mii_gender_editor import MiiGenderEditor
from scenes.setting_mii.mii_glass_editor import MiiGlassEditor
from scenes.setting_mii.mii_hairstyle_editor import MiiHairstyleEditor
from scenes.setting_mii.mii_eyes_editor import MiiEyesEditor
from scenes.setting_mii.mii_mouth_editor import MiiMouthEditor
from scenes.setting_mii.mii_beautyspot_editor import MiiHokuroEditor
from scenes.setting_mii.mii_bodystyle_editor import MiiBodyStyleEditor
from scenes.setting_mii.mii_favoritecolor_editor import MiiFavoriteColorEditor
from scenes.setting_mii.mii_nickname_editor import MiiNicknameEditor
from kiki.util.log import file_logger as logger
from testcases.examples.utility import touch_nth_icon_from_matrix


import time
_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"


class MiiEdit(BaseScene):
    def __init__(self, driver):
        super(MiiEdit, self).__init__(driver)
        self.f_editor = MiiFaceEditor(driver)
        self.eb_editor = MiiEyebrowsEditor(driver)
        self.n_editor = MiiNoseEditor(driver)
        self.mus_editor = MiiMustacheEditor(driver)
        self.ge_editor = MiiGenderEditor(driver)
        self.gl_editor = MiiGlassEditor(driver)
        self.hs_editor = MiiHairstyleEditor(driver)
        self.ey_editor = MiiEyesEditor(driver)
        self.mt_editor = MiiMouthEditor(driver)
        self.bs_editor = MiiHokuroEditor(driver)
        self.bd_editor = MiiBodyStyleEditor(driver)
        self.fc_editor = MiiFavoriteColorEditor(driver)
        self.nn_editor = MiiNicknameEditor(driver)

    def is_available(self):
        icon_image_list = [
                           _ICON_IMAGE_PATH + "ss_mii_title.png",
                            ]

        for icon_image in icon_image_list:
            if self.driver.screen.detect_object_with_image(icon_image) is not None:
                return True

            else:
                return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してMiiEditにいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="scene\[SceneSetMii\] exitScene"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def search_icon(self, name, shows_result=False):
        if type(name) == list:
            for image_name in name:
                icon_image = _ICON_IMAGE_PATH + image_name
                icon = icon_image
                result = self.driver.screen.detect_object_with_image(icon, shows_result=shows_result)
                if result is not None:
                    return result[0], result[1]
            return None
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon = icon_image
            result = self.driver.screen.detect_object_with_image(icon, shows_result=shows_result)
            if result is not None:
                return result[0], result[1]
            else:
                return None

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.window.detect_object(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def set_face(self, outline_id=None, cheek_id=None, wrinkle_id=None, color_id=None):
        self.driver.screen.touch(0,x=80, y=75, ms_after=500)
        self.f_editor.set_face_settings(outline_id, cheek_id,wrinkle_id,color_id)

    def set_eyebrows(self,eyebrows_parts_id=None,eyebrows_pos=None,eyebrows_width=None,eyebrows_incline=None,eyebrows_size=None,eyebrows_height=None,eyebrows_color_id=None):
        self.driver.screen.touch(0,x=80, y=150, ms_after=500)
        self.eb_editor.set_eyebrows_settings(eyebrows_parts_id,eyebrows_pos,eyebrows_width,
                                             eyebrows_incline,eyebrows_size,eyebrows_height,eyebrows_color_id)

    def set_nose(self,nose_parts_id=None,nose_pos=None,nose_size=None):
        self.driver.screen.touch(0,x=80, y=220, ms_after=500)
        self.n_editor.set_nose_settings(nose_parts_id,nose_pos,nose_size)

    def set_mustache(self,mustache_parts_id=None,beard_parts_id=None,mustache_pos=None,mustache_size=None,mustache_color_id=None):
        self.driver.screen.touch(0,x=80, y=290, ms_after=500)
        self.mus_editor.set_mustache_settings(mustache_parts_id,beard_parts_id,mustache_pos,mustache_size,mustache_color_id)

    def set_gender(self,gender_id=None):
        self.driver.screen.touch(0,x=80, y=360, ms_after=500)
        self.ge_editor.set_gender_settings(gender_id)

    def set_glass(self,glass_parts_id=None,glass_pos=None,glass_size=None,glass_color_id=None):
        self.driver.screen.touch(0,x=80, y=430, ms_after=500)
        self.gl_editor.set_glass_settings(glass_parts_id,glass_pos,glass_size,glass_color_id)

    def set_hairstyle(self,hairstyle_parts_id=None,hairstyle_color_id=None):
        self.driver.screen.touch(0,x=380, y=75, ms_after=500)
        self.hs_editor.set_hairstyle_settings(hairstyle_parts_id,hairstyle_color_id)

    def set_eyes(self,eyes_parts_id=None,eyes_pos=None,eyes_width=None,eyes_incline=None,eyes_size=None,eyes_height=None,eyes_color_id=None):
        self.driver.screen.touch(0,x=380, y=150, ms_after=500)
        self.ey_editor.set_eyes_settings(eyes_parts_id,eyes_pos,eyes_width,eyes_incline,eyes_size,eyes_height,eyes_color_id)

    def set_mouth(self,mouth_parts_id=None,mouth_pos=None,mouth_size=None,mouth_height=None,mouth_color_id=None):
        self.driver.screen.touch(0,x=380, y=220, ms_after=500)
        self.mt_editor.set_mouth_settings(mouth_parts_id,mouth_pos,mouth_size,mouth_height,mouth_color_id)

    def set_hokuro(self,hokuro_parts_id=None,hokuro_pos_y=None,hokuro_pos_x=None,hokuro_size=None):
        self.driver.screen.touch(0,x=380, y=290, ms_after=500)
        self.bs_editor.set_hokuro_settings(hokuro_parts_id,hokuro_pos_y,hokuro_pos_x,hokuro_size)

    def set_body_style(self,body_height=None,body_weight=None):
        self.driver.screen.touch(0,x=380, y=360, ms_after=500)
        self.bd_editor.set_bodystyle_settings(body_height,body_weight)

    def set_favorite_color(self,favoritecolor_id=None):
        self.driver.screen.touch(0,x=380, y=430, ms_after=500)
        self.fc_editor.set_favoritecolor_settings(favoritecolor_id)

    def set_nickname(self, logstore, nickname="default" ,language="jp"):
        self.driver.screen.touch(0,x=380, y=525, ms_after=2000)
        self.nn_editor.set_nickname_settings(nickname,language, logstore)

    def establish_a_mii(self):
        self.driver.screen.touch(0,x=330, y=585, ms_after=500)

    def create_a_mii_from_params(self, logstore, outline_id=None, cheek_id=None, wrinkle_id=None, color_id=None,
                                 eyebrows_parts_id=None,eyebrows_pos=None,eyebrows_width=None,eyebrows_incline=None,
                                 eyebrows_size=None,eyebrows_height=None,eyebrows_color_id=None,
                                 nose_parts_id=None,nose_pos=None,nose_size=None,
                                 mustache_parts_id=None,beard_parts_id=None,mustache_pos=None,mustache_size=None,mustache_color_id=None,
                                 gender_id=None,
                                 glass_parts_id=None,glass_pos=None ,glass_size=None ,glass_color_id=None,
                                 hairstyle_parts_id=None,hairstyle_color_id=None,
                                 eyes_parts_id=None,eyes_pos=None,eyes_width=None,eyes_incline=None,eyes_size=None,
                                 eyes_height=None,eyes_color_id=None,
                                 mouth_parts_id=None,mouth_pos=None,mouth_size=None,mouth_height=None,mouth_color_id=None,
                                 hokuro_parts_id=None,hokuro_pos_y=None,hokuro_pos_x=None,hokuro_size=None,
                                 body_height=None,body_weight=None,
                                 favoritecolor_id=None,nickname="default",language="jp"):

        self.driver.screen.touch(0,x=135, y=235, ms_after=500)
        self.driver.screen.touch(0,x=535, y=210, ms_after=500)
        self.driver.screen.touch(0,x=520, y=350, ms_after=2000)
        icon_image = [_ICON_IMAGE_PATH + "mii_editor_menu_icon_01.PNG"]
        self.driver.screen.wait_until_detect_object(icon_image,threshold=0.3)

        self.set_face(outline_id, cheek_id, wrinkle_id, color_id)
        self.set_eyebrows(eyebrows_parts_id,eyebrows_pos,eyebrows_width,eyebrows_incline,eyebrows_size,eyebrows_height,eyebrows_color_id)
        self.set_nose(nose_parts_id,nose_pos,nose_size)
        self.set_mustache(mustache_parts_id,beard_parts_id,mustache_pos,mustache_size,mustache_color_id)
        self.set_gender(gender_id)
        self.set_glass(glass_parts_id,glass_pos,glass_size,glass_color_id)
        self.set_hairstyle(hairstyle_parts_id,hairstyle_color_id)
        self.set_eyes(eyes_parts_id,eyes_pos,eyes_width,eyes_incline,eyes_size,eyes_height,eyes_color_id)
        self.set_mouth(mouth_parts_id,mouth_pos,mouth_size,mouth_height,mouth_color_id)
        self.set_hokuro(hokuro_parts_id,hokuro_pos_y,hokuro_pos_x,hokuro_size)
        self.set_body_style(body_height,body_weight)
        self.set_favorite_color(favoritecolor_id)
        self.set_nickname(logstore, nickname,language)
        time.sleep(0.5)
        self.establish_a_mii()


    def select_nth_mii(self,n=0):
        touch_nth_icon_from_matrix(self.driver,number=n,x_org=555,y_org=225,row_num= 4,cal_num=2,
                                   x_apart=180,y_apart=275)

    def edit_nth_mii_from_list(self,n, logstore, outline_id=None, cheek_id=None, wrinkle_id=None, color_id=None,
                                 eyebrows_parts_id=None,eyebrows_pos=None,eyebrows_width=None,eyebrows_incline=None,
                                 eyebrows_size=None,eyebrows_height=None,eyebrows_color_id=None,
                                 nose_parts_id=None,nose_pos=None,nose_size=None,
                                 mustache_parts_id=None,beard_parts_id=None,mustache_pos=None,mustache_size=None,mustache_color_id=None,
                                 gender_id=None,
                                 glass_parts_id=None,glass_pos=None ,glass_size=None ,glass_color_id=None,
                                 hairstyle_parts_id=None,hairstyle_color_id=None,
                                 eyes_parts_id=None,eyes_pos=None,eyes_width=None,eyes_incline=None,eyes_size=None,
                                 eyes_height=None,eyes_color_id=None,
                                 mouth_parts_id=None,mouth_pos=None,mouth_size=None,mouth_height=None,mouth_color_id=None,
                                 hokuro_parts_id=None,hokuro_pos_y=None,hokuro_pos_x=None,hokuro_size=None,
                                 body_height=None,body_weight=None,
                                 favoritecolor_id=None,nickname="default",language="jp"):

        self.driver.screen.touch(0,x=135, y=150, ms_after=500)
        self.select_nth_mii(n)
        self.driver.screen.touch(0,x=135, y=345, ms_after=500)
        icon_image = [_ICON_IMAGE_PATH + "mii_editor_menu_icon_01.PNG"]
        self.driver.screen.wait_until_detect_object(icon_image,threshold=0.3)
        self.set_face(outline_id, cheek_id, wrinkle_id, color_id)
        self.set_eyebrows(eyebrows_parts_id,eyebrows_pos,eyebrows_width,eyebrows_incline,eyebrows_size,eyebrows_height,eyebrows_color_id)
        self.set_nose(nose_parts_id,nose_pos,nose_size)
        self.set_mustache(mustache_parts_id,beard_parts_id,mustache_pos,mustache_size,mustache_color_id)
        self.set_gender(gender_id)
        self.set_glass(glass_parts_id,glass_pos,glass_size,glass_color_id)
        self.set_hairstyle(hairstyle_parts_id,hairstyle_color_id)
        self.set_eyes(eyes_parts_id,eyes_pos,eyes_width,eyes_incline,eyes_size,eyes_height,eyes_color_id)
        self.set_mouth(mouth_parts_id,mouth_pos,mouth_size,mouth_height,mouth_color_id)
        self.set_hokuro(hokuro_parts_id,hokuro_pos_y,hokuro_pos_x,hokuro_size)
        self.set_body_style(body_height,body_weight)
        self.set_favorite_color(favoritecolor_id)
        self.set_nickname(logstore, nickname,language)
        time.sleep(1)
        self.establish_a_mii()

    def delete_nth_mii_from_list(self,n):
        self.driver.screen.touch(0,x=135, y=150, ms_after=800)
        self.select_nth_mii(n)
        self.driver.screen.touch(0,x=135, y=425, ms_after=800)
        self.driver.screen.touch(0,x=810, y=485, ms_after=800)

    def start_search_host(self):
        self.driver.screen.touch(0,x=800, y=360, ms_after=800)
        icon_image = [_ICON_IMAGE_PATH + "ss_nx_detected_icon.PNG"]
        self.driver.screen.wait_until_detect_object(icon_image,threshold=0.6)

    def start_search_client(self):
        pass


