# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from testcases.examples.utility import touch_bar_point_percent_of

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH

_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"

class MiiBodyStyleEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiBodyStyleEditor, self).__init__(driver)

    def select_bodystyle(self,style_info):
        # 身長体重の設定値を上から順にリストでもらい、該当する引数のレベルの位置をタッチする
        #percentage = argument / argument_num
        #touch_bar_point_percent_of(self.driver,start_x=252,start_y=215,angle=0,bar_length=256,percentage=percentage)

        arg = style_info
        max_arg = [127,127]
        percentages =[]
        for n in range(len(arg)):
            if arg[n] is not None :
                percentages.append(arg[n] / max_arg[n])
            else:
                percentages.append(arg[n])

        bar_y_pos =330
        for x in percentages:
            if x is not None:
                touch_bar_point_percent_of(self.driver,start_x=252,start_y=bar_y_pos,angle=0,bar_length=256,percentage=x)
            bar_y_pos += 100

    def set_bodystyle_settings(self,body_height,body_weight):
        bodystyle_info = [body_height,body_weight]
        self.select_bodystyle(bodystyle_info)
        self.back_to_edit_menu()

