# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals



from HACDllDriver import factory, Button, CaptureMode
from params.winpos import WIN_POS
from res.res_path import RES_PATH
from scenes.t_base_scene import TBaseScene

from kiki.util.log import file_logger as logger


_ICON_IMAGE_PATH = RES_PATH + "/news_list/"

class TNewsList(TBaseScene):
    def __init__(self, driver):
        super(TNewsList, self).__init__(driver)

    def is_available(self):
        image = _ICON_IMAGE_PATH + "ss_news_list_title_jp.PNG"
        if self.driver.screen.detect_object_with_image(image) is not None:
            return True
        else:
            return False

    def transit_to_search_channel(self, id=0):
        self.driver.controllers[id].push("START", ms_after=1000)

    def transit_to_news_detail(self, tmb_name, id=0):
        # 渡されたサムネイルと一致するニュースの詳細画面へ遷移する
        # システムニュース( とりあえずショップの説明 )が見えたら、発見できなかったとして終了する
        # ※ピックアップニュース非対応※
        x_list = [[90, 105], [457, 470], [825, 840]]

        image = _ICON_IMAGE_PATH + tmb_name
        sys_image = _ICON_IMAGE_PATH + "news_system_thumbnail.png"
        self.driver.controllers[id].push("DOWN", ms_after=1000)

        for row in range(50): # とりあえず50行
            result = self.driver.screen.detect_object_with_image(image)
            if result is None:
                self.driver.controllers[id].push("DOWN", ms_after=500)
                if self.driver.screen.detect_object_with_image(sys_image) is not None:
                    # システムニュースが表示されるところまできた。終わり。
                    return False
            else:
                # print(result)
                for i in range(3):
                    if result[0] in range(x_list[i][0], x_list[i][1]):
                        # print("result[0] = {0}, i = {1}".format(result[0], i))
                        for n in range(i):
                            self.driver.controllers[id].push("RIGHT", ms_after=500)
                        self.driver.controllers[id].push("A", ms_after=1000)
                        return True

        return False

class TNewsSearchChannel(TBaseScene):
    def __init__(self, driver):
        super(TNewsSearchChannel, self).__init__(driver)

    def is_available(self):
        image = _ICON_IMAGE_PATH + "search_channel_title.png"
        if self.driver.screen.detect_object_with_image(image) is not None:
            return True
        else:
            return False

if __name__ == "__main__":
    logger.info("program start")
    logger.info("============================================")

    with factory(*WIN_POS, capture=CaptureType.AmaRec, is_open_logreader=False) as _driver:
        _driver.controllers.add(0)
        _scene = TNewsList(_driver)
        _scene.reboot_by_target_manager()
        print("end")