# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from HACDllDriver import factory, Button, CaptureMode
from params.winpos import WIN_POS
from res.res_path import RES_PATH

from kiki.util.log import file_logger as logger
from scenes.home_menu.t_home_menu import THomeMenu
from scenes.t_base_scene import TBaseScene
from config.confmgr import CONF

_ICON_IMAGE_PATH = RES_PATH + "/main_setting/"

class TMainSetting(TBaseScene):
    def __init__(self, driver):
        super(TMainSetting, self).__init__(driver)

    def is_available(self):
        icon_name_list = [
            "main_setting.png",
            "main_setting_USen.png",
            "main_setting_EUen.png"
        ]

        for icon_name in icon_name_list:
            main_setting_icon = _ICON_IMAGE_PATH + icon_name
            if self.driver.screen.detect_object_with_image(main_setting_icon) is not None:
                return True
        return False


    def select_left_menu_by_keys(self, name):
        menu_dict = {
            "サポート": 0,
            "機内モード": 1,
            "画面の明るさ": 2,
            "ロック": 3,
            "みまもり設定": 4,
            "インターネット": 5,
            "データ管理": 6,
            "ユーザー": 7,
            "Mii": 8,
            "amiibo": 9,
            "テーマ": 10,
            "通知": 11,
            "スリープ": 12,
            "コントローラーとセンサー": 13,
            "テレビ出力": 14,
            "本体": 15
        }

        for i in range(10):
            if self.is_available():
                break
            else:
                time.sleep(1)

        logger.info("設定画面：左側のメニューより" + name + "を選択します。")

        # カーソル位置を初期化(サポートへ)
        self.driver.controllers[0].push("UP", ms_press=2000, ms_after=1000)

        # サポート以外
        if name != "サポート":
            key_down_num = menu_dict[name]
            for i in range(key_down_num):
                self.driver.controllers[0].push("DOWN", ms_after=500)

        self.driver.controllers[0].push("A", ms_after=500)


    def select_system_menu(self, btn_name, id=0):
        btn_dict = { "本体の更新": 0,
                     "本体のニックネーム": 1,
                     "言語": 2,
                     "地域": 3,
                     "日付と時刻": 4,
                     "本体のバッテリー残量": [],
                     "サウンド": [],
                     "ヘッドホンを抜いたときに消音": [],
                     "ヘッドホンの最大音量を下げる": [ _ICON_IMAGE_PATH + "lower_max_headphone_volume_A.png",
                                                       _ICON_IMAGE_PATH + "lower_max_headphone_volume_B.png"],
                     "画面の色合いを変える": [],
                     "シリアル情報": [],
                     "利用規約": [ _ICON_IMAGE_PATH + "eula_A.png",
                                   _ICON_IMAGE_PATH + "eula_B.png"],
                     "知的財産の表記": [ _ICON_IMAGE_PATH + "intellectual_property_notices_A.png",
                                         _ICON_IMAGE_PATH + "intellectual_property_notices_B.png" ],
                     "認証表示": [ _ICON_IMAGE_PATH + "hardware_auth_A.png",
                                   _ICON_IMAGE_PATH + "hardware_auth_B.png"],
                     "ソフトの自動更新": -4,
                     "ゲームニュースのチャンネル設定": -3,
                     "エラーレポートの送信": -2,
                     "初期化": -1}

        logger.info("設定画面: 本体 のメニュー群より {0} を選択します".format(btn_name))

        if type(btn_dict[btn_name]) == int:
            if btn_dict[btn_name] >= 0:
                self.driver.controllers[id].push("UP", ms_press=3000, ms_after=1000)
                for i in range(btn_dict[btn_name]):
                    self.driver.controllers[id].push("DOWN", ms_after=500)
                self.driver.controllers[id].push("A", ms_after=1000)
                return
            else:
                self.driver.controllers[id].push("DOWN", ms_press=4000, ms_after=1000)
                for i in range(abs(btn_dict[btn_name]) - 1):
                    self.driver.controllers[id].push("UP", ms_after=500)
                self.driver.controllers[id].push("A", ms_after=1000)
                return
        else:
            self.driver.controllers[id].push("UP", ms_press=3000, ms_after=1000)
            for i in range(50):
                self.driver.controllers[id].push("DOWN", ms_after=500)
                for img in btn_dict[btn_name]:
                    if self.driver.screen.detect_object_with_image(img, threshold=0.995) is not None:
                        self.driver.controllers[id].push("A", ms_after=1000)
                        return

    def select_user_menu(self, btn_name, id=0):
        # ユーザーの選択はここではしない。
        image = _ICON_IMAGE_PATH + "skip_select_UA_btn.png"
        num = 0
        if self.driver.screen.detect_object_with_image(image) is not None:
            # UA が 1人のみ
            btn_dict = { "選択画面をスキップ": 2,
                         "あたらしいユーザーの追加": 1,
                         "ユーザーとセーブデータの引っ越し": 0}

            if btn_name == "並べ替え":
                logger.info("{0} ボタンは表示されていません。".format(btn_name))
                return False

            self.driver.controllers[id].push("DOWN", ms_press=2000, ms_after=1000)
            num = btn_dict[btn_name]
        else:
            # UA が 2人以上居る
            self.driver.controllers[id].push("DOWN", ms_press=2000, ms_after=1000)
            image = _ICON_IMAGE_PATH + "add_new_user_btn.png"
            if self.driver.screen.detect_object_with_image(image) is not None:
                # UAが 7人以下
                btn_dict = { "並べ替え": 2,
                             "あたらしいユーザーの追加": 1,
                             "ユーザーとセーブデータの引っ越し": 0}
                if btn_name == "選択画面をスキップ":
                    logger.info("{0} ボタンは表示されていません。".format(btn_name))
                    return False

                num = btn_dict[btn_name]
            else:
                # UAが 8人居る
                btn_dict = { "並べ替え": 1,
                             "ユーザーとセーブデータの引っ越し": 0}

                if btn_name == "選択画面をスキップ" or btn_name == "あたらしいユーザーの追加":
                    logger.info("{0} ボタンは表示されていません。".format(btn_name))
                    return False

                num = btn_dict[btn_name]

        for i in range(num):
            self.driver.controllers[id].push("UP", ms_after=500)
        self.driver.controllers[id].push("A", ms_after=1000)
        return True

    def is_transited_to_AP_list(self, id=0):
        image = _ICON_IMAGE_PATH + "searching_network.png"
        for i in range(30):
            if self.driver.screen.detect_object_with_image(image) is not None:
                time.sleep(2)
            else:
                time.sleep(3)
                return True
        else:
            logger.info("インターネット設定で、AP検索が終了せず、一覧が表示されませんでした。")
            return False

    def is_available_show_AP_list(self):
        image = _ICON_IMAGE_PATH + "AP_list_identity.png"
        for i in range(60):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        logger.info("インターネット設定で、登録済みのネットワークの表示がされませんでした。")
        return False

    def check_any_registered_AP(self, id=0):
        if not self.is_transited_to_AP_list(id):
            return False

        image_list = [ _ICON_IMAGE_PATH + "any_registered_AP_A.png",
                       _ICON_IMAGE_PATH + "any_registered_AP_B.png" ]
        for i in range(10):
            for image in image_list:
                if self.driver.screen.detect_object_with_image(image) is not None:
                    return True

        return False

    def delete_registered_AP(self, id=0):
        # AP一覧が表示されている状態から。
        self.driver.controllers[id].push("A", ms_after=1000)
        for i in range(2):
            self.driver.controllers[id].push("DOWN", ms_after=500)
        self.driver.controllers[id].push("A", ms_after=1000)
        self.driver.controllers[id].push("A", ms_after=1000)

        self.is_transited_to_AP_list()

    def check_connect_network(self):
        ok_img =  _ICON_IMAGE_PATH + "set_connect_success.png" 
        ng_img =  _ICON_IMAGE_PATH + "net_connect_ng.png" 

        for i in range(90):
            if self.driver.screen.detect_object_with_image(ok_img) is not None:
                return True
            elif self.driver.screen.detect_object_with_image(ng_img) is not None:
                return False

    def enable_incorrect_proxy_setting(self, id=0):
        # 設定の変更画面へ遷移してからの操作。
        # Proxy設定を「する」にして、サーバー 1 としてから保存する。
        image_list = [ _ICON_IMAGE_PATH + "proxy_setting_A.png",
                       _ICON_IMAGE_PATH + "proxy_setting_B.png"]
        image = _ICON_IMAGE_PATH + "proxy_setting_param.png"
        bs_image = _ICON_IMAGE_PATH + "enable_back_space.png"
        for i in range(15):
            for img in image_list:
                if self.driver.screen.detect_object_with_image(img, threshold=0.95) is not None:
                    self.driver.controllers[id].push("A", ms_after=1000)
                    self.driver.controllers[id].push("UP", ms_after=1000)
                    self.driver.controllers[id].push("A", ms_after=2000)  # 「する」 選択
                    break
            if self.driver.screen.detect_object_with_image(image) is not None:
                break

            self.driver.controllers[id].push("DOWN", ms_after=500)

        time.sleep(2)
        self.driver.controllers[id].push("DOWN", ms_after=1000)
        self.driver.controllers[id].push("A", ms_after=1000)
        time.sleep(2)
        if self.driver.screen.detect_object_with_image(bs_image, threshold=0.9) is not None:
            self.driver.controllers[id].push("B", ms_press=800, ms_after=1000)
        self.driver.controllers[id].push("A", ms_after=1000)  # サーバー を 1 にする
        self.driver.controllers[id].push("START", ms_after=1000)
        self.driver.controllers[id].push("RIGHT", ms_after=1000)
        self.driver.controllers[id].push("A", ms_after=1000)  # 保存する
        self.driver.controllers[id].push("A", ms_after=1000)

    def disable_incorrect_proxy_setting(self, id=0):
        image_list = [ _ICON_IMAGE_PATH + "proxy_setting_A.png",
                       _ICON_IMAGE_PATH + "proxy_setting_B.png"]
        flg = False

        for i in range(15):
            for img in image_list:
                if self.driver.screen.detect_object_with_image(img, threshold=0.95) is not None:
                    self.driver.controllers[id].push("A", ms_after=1000)
                    self.driver.controllers[id].push("DOWN", ms_after=1000)
                    self.driver.controllers[id].push("A", ms_after=2000)
                    flg = True
                    break
            if flg:
                break
            self.driver.controllers[id].push("DOWN", ms_after=500)

        self.driver.controllers[id].push("RIGHT", ms_after=1000)
        self.driver.controllers[id].push("A", ms_after=1000)

if __name__ == "__main__":
    logger.info("program start")
    logger.info("============================================")

    with factory(*WIN_POS, capture=CaptureType.DirectShow, play_mode=PlayMode.CRADLE, is_open_logreader=False) as _driver:
        _driver.controllers.add(0)
        n_list = ["選択画面をスキップ", "並べ替え", "あたらしいユーザーの追加", "ユーザーとセーブデータの引っ越し"]

        for i in range(len(n_list)):
            _driver.controllers[0].push("HOME", ms_after=3000)
            _scene = THomeMenu(_driver)
            _scene.select_system_applet("main_setting")
            time.sleep(2)

            _scene = TMainSetting(_driver)
            _scene.select_left_menu_by_keys("ユーザー")
            time.sleep(1)
            print(_scene.select_user_menu(n_list[i]))

        print("end")