# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


from scenes.base_scene import BaseScene

from res.res_path import RES_PATH
from kiki.util.log import file_logger as logger

_ICON_IMAGE_PATH = RES_PATH + "/applet_caller/"



class AppletCaller(BaseScene):
    def __init__(self, driver):
        super(AppletCaller, self).__init__(driver)
        #self.cur_nsa_requirement = self.get_cur_nsa_requirement()

    def is_available(self):
        setting_icon = _ICON_IMAGE_PATH + "setting_icon.png"
        if self.driver.screen.detect_object_with_image(setting_icon) is not None:
            return True
        else:
            return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してHOMEにいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<qlaunch\>.*\[ResidentMenu\].*\[TransittedToResidentMenu\]|\<qlaunch\>.*\[ResidentMenu\].*\[SceneDestroyed\]"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            setting_icon = _ICON_IMAGE_PATH + "ss_sa_icon_setting.PNG"
            if self.driver.screen.detect_object_with_image(setting_icon) is not None:
                return True
            else:
                return False

    def search_icon(self, icon_image_list, threshold=0.8, shows_result=False):
        """ホーム画面からアイコンを探す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        if not self.is_available():
            logger.warn("ホームメニューにいません。")
            return None

        self.driver.controllers[0].push("START", ms_after=500) # TODO: HOMEボタン対応後、HOMEボタンに変える

        full_launcher_L_bunner = _ICON_IMAGE_PATH+"full_launcher_L_banner.png"
        while self.driver.window.detect_object(full_launcher_L_bunner) is None:
            result = self._search_icon_from_image_list(icon_image_list, shows_result=shows_result)
            if result is not None:
                return result
            else:
                self.driver.controllers[0].push("RIGHT", ms_after=500)

        logger.info("アイコン見つからなかった…")
        return None

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def select_main_directory(self,directory_name):
        pass
        """
        directory_name_row = {
            "Auth"
            "Cabinet"
            "Controller"
            "DataErase"
            "Error"
            "NetConnect"
            "PhotoViewer"
            "PlayerSelect"
            "Swkbd"
            "SwkbdAsync"
            "MiiEdit"
            "MyPage"
            "option"
            "psel":
        }
        cur_directory =
        """

    def move_cursor_to_origin(self):
        for i in range(8):
            self.driver.controllers[0].push("UP",ms_after=200)

    def set_applet_boot_mode(self):
        boot_mode_icon = _ICON_IMAGE_PATH + "ss_appletcaller_psel_SelectUser.PNG"
        for i in range(8):
            if self.driver.screen.detect_object_with_image(boot_mode_icon) is not None:
                break
            else:
                self.driver.controllers[0].push("LEFT",ms_after=500)

    def move_cursor_to_nsa_requirement(self):
        for i in range(2):
            self.driver.controllers[0].push("DOWN",ms_after=200)

    def get_cur_nsa_requirement(self):
        requirement_icon = _ICON_IMAGE_PATH + "ss_appletcaller_psel_nsa_require_true.PNG"
        if self.driver.screen.detect_object_with_image(requirement_icon) is not None:
            return True
        else:
            return False

    def resume_app(self):
        self.driver.controllers[0].push("HOME")
        setting_icon = _ICON_IMAGE_PATH + "ss_sa_icon_setting.PNG"
        self.driver.screen.wait_until_detect_object(setting_icon,x=760,y=505,width=100, height=100, threshold=0.8,limit_count=50)

    def set_nsa_requirement(self,bool):
        pass
        """
        if self.cur_nsa_requirement is not bool:
            self.move_cursor_to_nsa_requirement()
            self.driver.controllers[0].push("LEFT",ms_after=500)
            for i in range(2):
                self.driver.controllers[0].push("UP",ms_after=200)
        """
