# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals
from scenes.base_scene import BaseScene
from scenes.base_scene import BaseScene
from kiki.util.log import file_logger as logger
from params.winpos import WIN_POS
from res.res_path import RES_PATH

import time

_ICON_IMAGE_PATH = RES_PATH + "/friend/"

class MyPage(BaseScene):
    def __init__ (self,driver):
        super(MyPage,self).__init__(driver)

    def is_available(self):
        icon_image_list = [_ICON_IMAGE_PATH + "ss_mypage_identity_JP.png",
                           _ICON_IMAGE_PATH + "ss_mypage_identity_US_EU.png"]

        for icon_image in icon_image_list:
            if self.driver.screen.detect_object_with_image(icon_image) is not None:
                return True
        else:
            return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してMypageにいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<myPage\>.*Scene Jump end \(success\) \[\/RootScene\/SceneMypNavMyPage\/SceneMypCntMyProfile.*\]"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def select_navibar_menu(self, name):
        # 左側のメニュー(ナビバーというそうな)から各メニューを選択する
        menu_dict = {"profile": 0,
                     "friend_list": 1,
                     "add_friend": 2,
                     "user_settings": 3}

        self.driver.controllers[0].push("UP", ms_press=1000, ms_after=500)
        for i in range(menu_dict[name]):
            self.driver.controllers[0].push("DOWN", ms_after=500)
        self.driver.controllers[0].push("A", ms_after=500)

    def search_icon(self, name, shows_result=False):
        if type(name) == list:
            for image_name in name:
                icon_image = _ICON_IMAGE_PATH + image_name
                icon = icon_image
                result = self.driver.screen.detect_object_with_image(icon, shows_result=shows_result)
                if result is not None:
                    return result[0], result[1]
            return None
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon = icon_image
            result = self.driver.screen.detect_object_with_image(icon, shows_result=shows_result)
            if result is not None:
                return result[0], result[1]
            else:
                return None

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def start_to_friend_req_uds(self):
        # 対面印象アイコンにカーソルを合わせてAボタンを押すことでローカルフレンド登録シーケンスの開始
        # マイページ入ってすぐの状態から実行すること
        for x in range(2):
            self.driver.controllers[0].push("DOWN", ms_after=100)
        self.driver.controllers[0].push("RIGHT", ms_after=100)
        for x in range(3):
            self.driver.controllers[0].push("DOWN", ms_after=100)
        self.driver.controllers[0].push("A", ms_after=100)

    def select_auth_icon(self,auth_icon):
        # 対面認証アイコンの選択　アイコンの並びは毎回ランダムらしいのでマークの種類を引数でもらって画像認証でやるしかない
        mark_image={
            "heart":[[_ICON_IMAGE_PATH + "ss_auth_icon_01.PNG"]],
            "spade":[[_ICON_IMAGE_PATH + "ss_auth_icon_02.PNG"]],
            "diamond":[[_ICON_IMAGE_PATH + "ss_auth_icon_03.PNG"]],
            "clover":[[_ICON_IMAGE_PATH + "ss_auth_icon_04.PNG"]]
        }
        icon_image = mark_image[auth_icon][0]
        result_pos = self._search_icon_from_image_list(icon_image_list=icon_image, threshold=0.9, shows_result=False)
        self.driver.screen.touch(0, x=result_pos[0], y=result_pos[1], ms_after=500)

    def keep_tapping_region_first_detected(self):
        # サーチアイコンが出なくなるまで1人目の場所をタッチし続ける
        is_searching = True
        while is_searching is True:
            icon_image = [_ICON_IMAGE_PATH + "ss_searching_icon_01.PNG",]
            result = self._search_icon_from_image_list(icon_image_list=icon_image, threshold=0.3, shows_result=False)

            if result is None:
                retry_icon_image = [_ICON_IMAGE_PATH + "ss_dlg_no_detected_01.PNG",]
                need_retry = self._search_icon_from_image_list(icon_image_list=retry_icon_image, threshold=0.8, shows_result=False)
                if need_retry is not None :
                    self.driver.screen.touch(0, x=800, y=450, ms_after=500)
                    time.sleep(2)
                else:is_searching = False
            else:
                self.driver.screen.touch(0, x=545, y=300, ms_after=500)
                time.sleep(1)
        print("escaped searching")
        self.driver.screen.touch(0, x=800, y=450, ms_after=1000)


    def count_for_available_accounts(self):
        application_image = [
            _ICON_IMAGE_PATH + "ss_searching_icon_01.PNG",
            ]
            #_ICON_IMAGE_PATH + "ss_searching_icon_02.PNG",
            #_ICON_IMAGE_PATH + "ss_searching_icon_03.PNG",
        result_pos = self._search_icon_from_image_list(icon_image_list = application_image, threshold=0.5, shows_result=False)
        print(result_pos)
        # 登録可能人数が何人いるか判定する



    #def
        # 登録可能人数が何人いるか判定し
        #  誰でもいいので最初に出てきた人から順番にリクエストしていく
        # ある程度時間を待って番号を指定して選択する

    def quit_friend_req_uds(self):
        self.driver.controllers[0].push("B", ms_after=500)

    def make_friend_with_each_other_uds(self,auth_icon= "heart"):
        self.start_to_friend_req_uds()
        self.select_auth_icon(auth_icon)
        time.sleep(2)
        self.keep_tapping_region_first_detected()
        self.quit_friend_req_uds()


