# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS

from scenes.base_scene import BaseScene
from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH


import time
from res.swkbd.chara_pos_dictionary import *

_ICON_IMAGE_PATH = RES_PATH + "/starter/"


class Starter(BaseScene):
    def __init__(self, driver):
        super(Starter, self).__init__(driver)
        self.page_pos = [ 998 + 30*i for i in range(8)]

    def get_cur_page(self):
        for i in range(8):
            in_page = self.driver.screen.check_color_dot(x=self.page_pos[i], y=54, color=(233, 78, 47))
            if in_page:
                return i
        return -1

    def is_available(self):
        pass

class StarterInternet(BaseScene):
    def __init__(self, driver):
        super(StarterInternet, self).__init__(driver)
        self.ap_images = {
            "SMC-NET-212":_ICON_IMAGE_PATH+"ss_ap_smc_net_212.bmp",
            "SMC-NET-257-a":_ICON_IMAGE_PATH+"ss_ap_smc_net_257-a.bmp",
        }
        self.suc_connect = _ICON_IMAGE_PATH+"ss_connect_test_success.bmp"

    def is_available(self):
        img = self.driver.screen.get_roi()
        if img[177][217][2] < 100:
            return True
        return False

    def search_access_points(self,name_ap):
        while not self.driver.screen.detect_object_with_image(self.ap_images[name_ap],threshold=0.9):
            self.driver.controllers[0].push("DOWN", ms_after=500)
        self.driver.controllers[0].push("A", ms_after=500)

    def wait_until_succeed_connection(self):
        result = self.driver.screen.wait_until_detect_object(self.suc_connect,threshold=1.0)
        while result is None:
            pass
        return True

class StarterCruiser(BaseScene):
    def __init__(self, driver):
        super(StarterCruiser, self).__init__(driver)

    def is_available(self):
        img = self.driver.screen.get_roi()
        if img[282][318][2] < 100:
            return True
        return False

    def link_page_is_available(self):
        img = self.driver.screen.get_roi()
        if img[144][222][2] < 10:
            return True
        return False

    def link_start_page_is_available(self):
        img = self.driver.screen.get_roi()
        if img[334][239][2] < 10:
            return True
        return False

    def is_link_finished(self):
        img = self.driver.screen.get_roi()
        if img[521][264][2] < 100:
            return True
        return False

    def is_act_set_finished(self):
        img = self.driver.screen.get_roi()
        if img[423][371][2] < 100:
            return True
        return False



