# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from res.res_path import RES_PATH
from scenes.t_base_scene import TBaseScene
from kiki.util.log import file_logger as logger
from sequences.SwkbdInputter import SwkbdInputter
_ICON_IMAGE_PATH = RES_PATH + "/eshop/"

class ShopN(TBaseScene):
    def __init__(self, driver):
        super(ShopN, self).__init__(driver)

    def is_available(self):
        # 機器認証画面ではなく、Shopトップページ
        image = _ICON_IMAGE_PATH + "eshop_top_page.png"
        for i in range(120):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def is_available_shop_authentication(self):
        # ショップ機器認証画面かどうか
        image = _ICON_IMAGE_PATH + "shop_authentication_identity.png"
        for i in range(25):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def is_available_reinput_password(self):
        image = _ICON_IMAGE_PATH + "shop_reinput_password.png"
        for i in range(15):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def pass_shop_authentication(self, id=0):
        # ショップ機器認証を通過する is_available_shop_authentication() が True であった後に呼ぶ
        # 次からスキップする を ON にして進める
        self.driver.controllers[id].push("A", ms_after=500)
        self.driver.controllers[id].push("DOWN", ms_after=1000)
        self.driver.controllers[id].push("A", ms_after=1000)

        # Basic認証を通過する
        self.input_user_authentication(save_flg=True)

        # パスワードの再入力画面を通過する
        if not self.is_available_reinput_password():
            logger.info("パスワードの再入力 画面へ遷移しませんでした。")
            return False

        time.sleep(2)
        self.driver.controllers[id].push("A", ms_after=1000)
        _si = SwkbdInputter(self.driver, strings="")
        _si.run()