# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from res.res_path import RES_PATH
from scenes.t_base_scene import TBaseScene


_ICON_IMAGE_PATH = RES_PATH + "/cruiser/"

class TCruiser(TBaseScene):
    def __init__(self, driver):
        super(TCruiser, self).__init__(driver)

    def is_available(self):
        pass

    def is_available_NA_login_page(self):
        image = _ICON_IMAGE_PATH + "ss_mail_icon.png"
        for i in range(120):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def is_available_input_login_info(self):
        image = _ICON_IMAGE_PATH + "input_mail_or_login_ID.png"
        for i in range(60):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def is_available_share_select_service(self):
        image = _ICON_IMAGE_PATH + "ss_share_app_identity.png"
        for i in range(60):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def is_available_movie_player(self, id=0):
        # 定期的にUPキーを押して、フッターを表示し続ける。
        # 動画の再生状態は問わない。
        image_list = [ _ICON_IMAGE_PATH + "web_app_movie_player_identity_pause.png",
                       _ICON_IMAGE_PATH + "web_app_movie_player_identity_play.png" ]
        for i in range(30):
            self.driver.controllers[id].push("UP", ms_after=300)
            for image in image_list:
                if self.driver.screen.detect_object_with_image(image) is not None:
                    return True
        return False