# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH
from scenes.t_base_scene import TBaseScene


_ICON_IMAGE_PATH = RES_PATH + "/controller_support/"


class TControllerSupport(TBaseScene):
    def __init__(self, driver):
        super(TControllerSupport, self).__init__(driver)

    def is_available(self):
        image = _ICON_IMAGE_PATH + "ss_consup_icon.png"
        for i in range(5):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def is_available_change_grip_and_order(self):
        image = _ICON_IMAGE_PATH + "change_grip_and_order_identity.png"
        for i in range(10):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def detect_controller_in_find_disconnect_controller(self, cont_type, id=0):
        # コントローラーをさがす に遷移した状態で開始
        # 探したいコントローラーの情報を辞書化
        cont_dict = { "ukyo_disconnect": [_ICON_IMAGE_PATH + "search_controller_disconnected_ukyo_A.png",
                                           _ICON_IMAGE_PATH + "search_controller_disconnected_ukyo_B.png"],
                      "sakyo_disconnect": [_ICON_IMAGE_PATH + "search_controller_disconnected_sakyo_A.png",
                                           _ICON_IMAGE_PATH + "search_controller_disconnected_sakyo_B.png"] }

        # TODO: BT_OFF検知と接続済みコントローラー過多の検知を書くこと

        # 指定されたコントローラーをさがす
        for i in range(10):
            for j in range(5):
                for image in cont_dict[cont_type]:
                    if self.driver.screen.detect_object_with_image(image, threshold=0.98) is not None:
                        logger.info("{0} 発見。".format(cont_type))
                        return True
            if i == 4:
                self.driver.controllers[id].push("LEFT", ms_press=2000, ms_after=500)
                self.driver.controllers[id].push("DOWN", ms_after=500)
            else:
                self.driver.controllers[id].push("RIGHT", ms_after=500)

        logger.info("{0} を発見できませんでした。".format(cont_type))
        return False