# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals



from res.res_path import RES_PATH
from scenes.t_base_scene import TBaseScene


_ICON_IMAGE_PATH = RES_PATH + "/common/"

class UserSetting(TBaseScene):
    def __init__(self, driver):
        super(UserSetting, self).__init__(driver)

    def is_available(self):
        pass

    def select_button(self, btn_name, id=0):
        btn_dict = { "ニックネーム": 0,
                     "アイコンの編集": 1,
                     "フレンド機能の設定": 2,
                     "ブロックリスト管理": 3,
                     "SNSへの投稿設定": [ _ICON_IMAGE_PATH + "sns_setting_A.png",
                                          _ICON_IMAGE_PATH + "sns_setting_B.png" ],
                     "ニンテンドーeショップの設定": [ _ICON_IMAGE_PATH + "shop_setting_A.png",
                                                      _ICON_IMAGE_PATH + "shop_setting_B.png" ],
                     "ダウンロード状況を更新": [""],
                     "サポート用の番号":[""],
                     "ニンテンドーアカウントとの連携を解除": -2,
                     "ユーザーの消去": -1 }

        if type(btn_dict[btn_name]) == int:
            if btn_dict[btn_name] >= 0:
                self.driver.controllers[id].push("UP", ms_press=3000, ms_after=500)
                for i in range(btn_dict[btn_name]):
                    self.driver.controllers[id].push("DOWN", ms_after=1000)
                self.driver.controllers[id].push("A", ms_after=1000)
                return
            else:
                self.driver.controllers[id].push("DOWN", ms_press=3000, ms_after=500)
                for i in range(abs(btn_dict[btn_name]) - 1):
                    self.driver.controllers[id].push("UP", ms_after=1000)
                self.driver.controllers[id].push("A", ms_after=1000)
                return
        else:
            self.driver.controllers[id].push("UP", ms_press=3000, ms_after=500)
            for i in range(30):
                self.driver.controllers[id].push("DOWN", ms_after=300)
                for img in btn_dict[btn_name]:
                    if self.driver.screen.detect_object_with_image(img, threshold=0.95) is not None:
                        self.driver.controllers[id].push("A", ms_after=1000)
                        return


