# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from res.res_path import RES_PATH
from scenes.common.t_swkbd import TSwkbd
from scenes.t_base_scene import TBaseScene
from sequences.SwkbdInputter import SwkbdInputter


_ICON_IMAGE_PATH = RES_PATH + "/common/"

class TPsel(TBaseScene):
    def __init__(self, driver):
        super(TPsel, self).__init__(driver)

    def is_available(self):
        pass

    def is_available_add_new_user(self):
        image = _ICON_IMAGE_PATH + "add_new_user_identity.png"
        for i in range(10):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def check_complete_linked_NA(self, id=0):
        image = _ICON_IMAGE_PATH + "ss_check_icon.png"
        for i in range(120):
            if self.driver.screen.detect_object_with_image(image) is not None:
                self.driver.controllers[id].push("A", ms_after=1000)
                return True
            else:
                time.sleep(1)
        return False

    def check_complete_unlinked_NA(self, id=0):
        image = _ICON_IMAGE_PATH + "unlinked_NA_dialog.png"
        for i in range(60):
            if self.driver.screen.detect_object_with_image(image) is not None:
                self.driver.controllers[id].push("A", ms_after=1000)
                return True
            else:
                time.sleep(1)
        return False

    def unlink_NA(self, id=0):
        self.driver.controllers[0].push("UP", ms_after=1000)
        self.driver.controllers[0].push("A", ms_after=1000)
        time.sleep(4)
        self.driver.controllers[0].push("UP", ms_after=1000)
        self.driver.controllers[0].push("A", ms_after=1000)

        image = _ICON_IMAGE_PATH + "complete_NA_unlink.png"
        for i in range(60):
            if self.driver.screen.detect_object_with_image(image) is not None:
                time.sleep(1)
                self.driver.controllers[id].push("A", ms_after=1000)
                return True
            else:
                time.sleep(1)
        return False

    def add_new_user_account(self, id=0):
        # ユーザー追加のトップページから登録完了( NA連携確認 )まで。
        self.driver.controllers[id].push("A", ms_after=1000)

        # アイコン選択( とりあえず一番左上のアイコンを選ぶ )
        self.driver.controllers[id].push("A", ms_after=1000)

        # ニックネーム入力
        # ( SwkbdInputter が 対応されるまでは 適当に文字入れるだけ。 )
        _scene = TSwkbd(self.driver)
        if not _scene.is_available():
            return False

        self.driver.controllers[id].push("RIGHT", ms_after=200)
        for i in range(3):
            self.driver.controllers[id].push("A", ms_after=500)
            self.driver.controllers[id].push("DOWN", ms_after=200)
        self.driver.controllers[id].push("START", ms_after=1000)

        # ユーザーを追加でOK
        time.sleep(2)
        self.driver.controllers[id].push("A", ms_after=1000)
        return True
