# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

"""
Date    : 2015/10/20
Update  : 2015/10/20

Purpose         :
  現在の時刻の文字列は頻繁に使うので、お手軽に利用できるようなモジュールを作ってみました。
 
"""
import datetime


def now_f():
    """アンダースコアありのミリ秒までの現在時刻の文字列を返します

    :return:時刻の文字列
    """
    return datetime.datetime.now().strftime("%Y%m%d_%H%M%S_%f")


def now_s():
    """アンダースコアありの秒までの現在時刻の文字列を返します

    :return:時刻の文字列
    """
    return datetime.datetime.now().strftime("%Y%m%d_%H%M%S")


def nowd():
    """日付の現在時刻の文字列を返します

    :return:時刻の文字列
    """
    return datetime.datetime.now().strftime("%Y%m%d")


def nowf():
    """アンダースコアなしのミリ秒までの現在時刻の文字列を返します

    :return:時刻の文字列
    """
    return datetime.datetime.now().strftime("%Y%m%d%H%M%S%f")


def nows():
    """アンダースコアなしの秒までの現在時刻の文字列を返します

    :return:時刻の文字列
    """
    return datetime.datetime.now().strftime("%Y%m%d%H%M%S")
