﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/base/testBase_Exit.h>
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>

#include "HidInputerWrapper.h"
#include "TestUtil.h"

/*
*   単体テスト
*   事前に InputDirector を起動しておく必要があります。
*/

void InitializeControllers()
{
    // ターゲットシリアル取得
    SerialNumberString serialNumber;
    GetTargetSerial(&serialNumber);

    // Hid ライブラリのラッパークラス
    hidInputer::HidInputerWrapper       hidInputerWrapper;

    // ライブラリ読み込み
    hidInputerWrapper.LoadHidLibrary();

    // 関数読み込み
    hidInputerWrapper.LoadFunctiontions();
    hidInputerWrapper.m_InitializeFunction(serialNumber);

    ReleaseAllController(&hidInputerWrapper);

    // ライブラリ解放テスト
    hidInputerWrapper.m_FinalizeFunction();
    hidInputerWrapper.ReleaseHidLibrary();
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    if (argc >= 2)
    {
        printf("#######################################\n");
        printf("  Specified serial: %s\n", argv[1]);
        printf("#######################################\n");
    }
    else
    {
        printf("Please specify serial number by argv[1]\n");
        nnt::Exit(1);
    }

    // 開始前に全てのコントローラーを切断
    InitializeControllers();

    ::testing::InitGoogleTest(&argc, argv);

    // 自動テスト用にバックグラウンドアプリの起動を待機
    ::Sleep(5000);

    const int exitCode = RUN_ALL_TESTS();

    nnt::Exit(exitCode);
}
