﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include "TestUtil.h"
#include "HidInputerWrapper.h"
#include "../Common/testAutoTestAssistTool_Util.h"

using namespace hidInputer;

// ライブラリ読み込み、解放確認
TEST( HidInputerSuite, HidRecord)
{
    // ターゲットシリアル取得
    SerialNumberString serialNumber;
    ASSERT_TRUE(GetTargetSerial(&serialNumber));

     // Hid ライブラリのラッパークラス
    HidInputerWrapper       hidInputerWrapper;
    std::string fileName = autoTestAssistTool::util::GetSdkRootPath().append("\\output.py");

    // ライブラリ読み込みテスト
    ASSERT_TRUE(hidInputerWrapper.LoadHidLibrary());

    // 関数読み込みテスト
    ASSERT_TRUE(hidInputerWrapper.LoadFunctiontions());

    // 初期化
    ASSERT_EQ(hidInputerWrapper.m_InitializeFunction(serialNumber), HidInputerResult::HidInputerResult_Success);


    // 未記録状態での、スクリプト出力
    ASSERT_EQ(hidInputerWrapper.m_ExportHidInputRecordsWithPythonScriptFunction(fileName.c_str()), HidInputerResult::HidInputerResult_Success);

    // 記録開始
    ASSERT_EQ(hidInputerWrapper.m_BeginHidInputRecordingFunction(), HidInputerResult::HidInputerResult_Success);

    // 記録中のスクリプト出力（失敗する）
    ASSERT_EQ(hidInputerWrapper.m_ExportHidInputRecordsWithPythonScriptFunction(fileName.c_str()), HidInputerResult::HidInputerResult_Unexpected);

    // 記録終了
    ASSERT_EQ(hidInputerWrapper.m_EndHidInputRecordingFunction(), HidInputerResult::HidInputerResult_Success);


    // 記録後の、スクリプト出力
    ASSERT_EQ(hidInputerWrapper.m_ExportHidInputRecordsWithPythonScriptFunction(fileName.c_str()), HidInputerResult::HidInputerResult_Success);

    // 終了処理
    hidInputerWrapper.m_FinalizeFunction();
    // ライブラリ解放テスト
    ASSERT_TRUE(hidInputerWrapper.ReleaseHidLibrary());
}
