﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "..\Common\testAutoTestAssistTool_Util.h"
#include "HidInputerWrapper.h"
#include <nnt/nntest.h>
#include <tchar.h>
#define DEBUG_LOG(...) printf(__VA_ARGS__)

namespace hidInputer
{
    HidInputerWrapper::HidInputerWrapper()
    {
    }

    HidInputerWrapper::~HidInputerWrapper()
    {
    }

    bool HidInputerWrapper::LoadHidLibrary()
    {
        auto libPath = autoTestAssistTool::util::GetSdkRootPath().append(
            "\\Tools\\AutoTestAssistTools\\Libraries\\HidInputer.dll");
        m_ModuleHandle = ::LoadLibraryA(libPath.c_str());
        return (m_ModuleHandle != NULL);
    }

    bool HidInputerWrapper::ReleaseHidLibrary()
    {
        int result =  FreeLibrary(m_ModuleHandle);

        if (result == 0)
        {
            return false;
        }
        return true;
    }


    bool HidInputerWrapper::LoadFunctiontions()
    {
        bool loadLibraryResult = true;

        m_InitializeFunction = (InitializeFunction)GetProcAddress(m_ModuleHandle, "Initialize");
        if (m_InitializeFunction == NULL)
        {
            DEBUG_LOG("Initialize is not found");
            loadLibraryResult = false;
        }
        m_InitializeForLocalFunction = (InitializeForLocalFunction)GetProcAddress(m_ModuleHandle, "InitializeForLocal");
        if (m_InitializeForLocalFunction == NULL)
        {
            DEBUG_LOG("InitializeForLocal is not found");
            loadLibraryResult = false;
        }
        m_FinalizeFunction = (FinalizeFunction)GetProcAddress(m_ModuleHandle, "Finalize");
        if(m_FinalizeFunction == NULL)
        {
            DEBUG_LOG("Finalize is not found");
            loadLibraryResult = false;
        }

        // コントローラー接続関数読み込み
        if (!LoadControllerFunctions())
        {
            loadLibraryResult = false;
        }

        // ボタン、スティック操作関数読み込み
        if (!LoadButtonStickFunctions())
        {
            loadLibraryResult = false;
        }

        // タッチ操作関数読み込み
        if (!LoadTouchScreenFunctions())
        {
            loadLibraryResult = false;
        }

        // Hid 記録関数読み込み
        if (!LoadRecordingFunctions())
        {
            loadLibraryResult = false;
        }

        return loadLibraryResult;
    }

    bool HidInputerWrapper::LoadControllerFunctions()
    {
        bool loadLibraryResult = true;

        m_AddControllerFunction = (AddControllerFunction)GetProcAddress(m_ModuleHandle, "AddController");
        if(m_AddControllerFunction == NULL)
        {
            DEBUG_LOG("AddController is not found");
            loadLibraryResult = false;
        }
        m_AddControllerForIdFunction = (AddControllerForIdFunction)GetProcAddress(m_ModuleHandle, "AddControllerForId");
        if(m_AddControllerForIdFunction == NULL)
        {
            DEBUG_LOG("AddControllerForId is not found");
            loadLibraryResult = false;
        }
        m_ReleaseControllerFunction = (ReleaseControllerFunction)GetProcAddress(m_ModuleHandle, "ReleaseController");
        if(m_ReleaseControllerFunction == NULL)
        {
            DEBUG_LOG("ReleaseController is not found");
            loadLibraryResult = false;
        }
        m_AddDebugControllerFunction = (AddDebugControllerFunction)GetProcAddress(m_ModuleHandle, "AddDebugController");
        if(m_AddDebugControllerFunction == NULL)
        {
            DEBUG_LOG("AddDebugController is not found");
            loadLibraryResult = false;
        }
        m_AddControllerWithDeviceInfoFunction = (AddControllerWithDeviceInfoFunction)GetProcAddress(m_ModuleHandle, "AddControllerWithDeviceInfo");
        if (m_AddControllerWithDeviceInfoFunction == NULL)
        {
            DEBUG_LOG("AddControllerWithDeviceInfo is not found");
            loadLibraryResult = false;
        }
        m_GetConnectedControllerCountFunction = (GetConnectedControllerCountFunction)GetProcAddress(m_ModuleHandle, "GetConnectedControllerCount");
        if (m_GetConnectedControllerCountFunction == NULL)
        {
            DEBUG_LOG("GetConnectedControllerCount is not found");
            loadLibraryResult = false;
        }
        m_GetConnectedControllerIdsFunction = (GetConnectedControllerIdsFunction)GetProcAddress(m_ModuleHandle, "GetConnectedControllerIds");
        if (m_GetConnectedControllerIdsFunction == NULL)
        {
            DEBUG_LOG("GetConnectedControllerIds is not found");
            loadLibraryResult = false;
        }
        m_GetConnectedControllerDeviceInfoFunction = (GetConnectedControllerDeviceInfoFunction)GetProcAddress(m_ModuleHandle, "GetConnectedControllerDeviceInfo");
        if (m_GetConnectedControllerDeviceInfoFunction == NULL)
        {
            DEBUG_LOG("GetConnectedControllerDeviceInfo is not found");
            loadLibraryResult = false;
        }
        m_GetConnectedDebugControllerCountFunction = (GetConnectedDebugControllerCountFunction)GetProcAddress(m_ModuleHandle, "GetConnectedDebugControllerCount");
        if (m_GetConnectedDebugControllerCountFunction == NULL)
        {
            DEBUG_LOG("GetConnectedDebugControllerCount is not found");
            loadLibraryResult = false;
        }
        m_GetConnectedDebugControllerIdsFunction = (GetConnectedDebugControllerIdsFunction)GetProcAddress(m_ModuleHandle, "GetConnectedDebugControllerIds");
        if (m_GetConnectedDebugControllerIdsFunction == NULL)
        {
            DEBUG_LOG("GetConnectedDebugControllerIds is not found");
            loadLibraryResult = false;
        }
        return loadLibraryResult;
    }


    bool HidInputerWrapper::LoadButtonStickFunctions()
    {
        bool loadLibraryResult = true;

        m_PressButtonFunction = (PressButtonFunction)GetProcAddress(m_ModuleHandle, "PressButton");
        if(m_PressButtonFunction == NULL)
        {
            DEBUG_LOG("PressButton is not found");
            loadLibraryResult = false;
        }
        m_ReleaseButtonFunction = (ReleaseButtonFunction)GetProcAddress(m_ModuleHandle, "ReleaseButton");
        if(m_ReleaseButtonFunction == NULL)
        {
            DEBUG_LOG("ReleaseButton is not found");
            loadLibraryResult = false;
        }
        m_PushButtonFunction = (PushButtonFunction)GetProcAddress(m_ModuleHandle, "PushButton");
        if(m_PushButtonFunction == NULL)
        {
            DEBUG_LOG("PushButton is not found");
            loadLibraryResult = false;
        }
        m_PressMultiButtonFunction = (PressMultiButtonFunction)GetProcAddress(m_ModuleHandle, "PressMultiButton");
        if(m_PressMultiButtonFunction == NULL)
        {
            DEBUG_LOG("PressMultiButton is not found");
            loadLibraryResult = false;
        }
        m_ReleaseMultiButtonFunction = (ReleaseMultiButtonFunction)GetProcAddress(m_ModuleHandle, "ReleaseMultiButton");
        if(m_ReleaseMultiButtonFunction == NULL)
        {
            DEBUG_LOG("ReleaseMultiButton is not found");
            loadLibraryResult = false;
        }
        m_PushMultiButtonFunction = (PushMultiButtonFunction)GetProcAddress(m_ModuleHandle, "PushMultiButton");
        if(m_PushMultiButtonFunction == NULL)
        {
            DEBUG_LOG("PushMultiButton is not found");
            loadLibraryResult = false;
        }
        m_PushMultiSeqFunction = (PushMultiSeqFunction)GetProcAddress(m_ModuleHandle, "PushMultiSeq");
        if(m_PushMultiSeqFunction == NULL)
        {
            DEBUG_LOG("PushMultiSeq is not found");
            loadLibraryResult = false;
        }
        m_ResetControllerStateFunction = (ResetControllerStateFunction)GetProcAddress(m_ModuleHandle, "ResetControllerState");
        if(m_ResetControllerStateFunction == NULL)
        {
            DEBUG_LOG("SetDefault is not found");
            loadLibraryResult = false;
        }
        m_SetControllerStateFunction = (SetControllerStateFunction)GetProcAddress(m_ModuleHandle, "SetControllerState");
        if (m_SetControllerStateFunction == NULL)
        {
            DEBUG_LOG("SetControllerState is not found");
            loadLibraryResult = false;
        }
        m_HoldAnalogStickFunction = (HoldAnalogStickFunction)GetProcAddress(m_ModuleHandle, "HoldAnalogStick");
        if(m_HoldAnalogStickFunction == NULL)
        {
            DEBUG_LOG("HoldAnalogStick is not found");
            loadLibraryResult = false;
        }
        m_ReleaseAnalogStickFunction = (ReleaseAnalogStickFunction)GetProcAddress(m_ModuleHandle, "ReleaseAnalogStick");
        if(m_ReleaseAnalogStickFunction == NULL)
        {
            DEBUG_LOG("ReleaseAnalogStick is not found");
            loadLibraryResult = false;
        }
        m_TiltAnalogStickFunction = (TiltAnalogStickFunction)GetProcAddress(m_ModuleHandle, "TiltAnalogStick");
        if(m_TiltAnalogStickFunction == NULL)
        {
            DEBUG_LOG("TiltAnalogStick is not found");
            loadLibraryResult = false;
        }

        return loadLibraryResult;

    }
    bool HidInputerWrapper::LoadTouchScreenFunctions()
    {
        bool loadLibraryResult = true;
        m_TouchPressDownFunction = (TouchPressDownFunction)GetProcAddress(m_ModuleHandle, "TouchPressDown");
        if(m_TouchPressDownFunction == NULL)
        {
            DEBUG_LOG("TouchPressDown is not found");
            loadLibraryResult = false;
        }
        m_TouchPressDownWithFingerIdFunction = (TouchPressDownWithFingerIdFunction)GetProcAddress(m_ModuleHandle, "TouchPressDownWithFingerId");
        if(m_TouchPressDownWithFingerIdFunction == NULL)
        {
            DEBUG_LOG("TouchPressDownWithFingerId is not found");
            loadLibraryResult = false;
        }
        m_TouchPressUpFunction = (TouchPressUpFunction)GetProcAddress(m_ModuleHandle, "TouchPressUp");
        if(m_TouchPressUpFunction == NULL)
        {
            DEBUG_LOG("TouchPressUp is not found");
            loadLibraryResult = false;
        }
        m_TouchMoveFunction = (TouchMoveFunction)GetProcAddress(m_ModuleHandle, "TouchMove");
        if(m_TouchMoveFunction == NULL)
        {
            DEBUG_LOG("TouchMove is not found");
            loadLibraryResult = false;
        }
        m_TapFunction = (TapFunction)GetProcAddress(m_ModuleHandle, "Tap");
        if(m_TapFunction == NULL)
        {
            DEBUG_LOG("Tap is not found");
            loadLibraryResult = false;
        }
        m_DragAngleFunction = (DragAngleFunction)GetProcAddress(m_ModuleHandle, "DragAngle");
        if(m_DragAngleFunction == NULL)
        {
            DEBUG_LOG("DragAngle is not found");
            loadLibraryResult = false;
        }
        m_DragPosFunction = (DragPosFunction)GetProcAddress(m_ModuleHandle, "DragPos");
        if(m_DragPosFunction == NULL)
        {
            DEBUG_LOG("DragPos is not found");
            loadLibraryResult = false;
        }
        m_SetTouchStateFunction = (SetTouchStateFunction)GetProcAddress(m_ModuleHandle, "SetTouchState");
        if (m_SetTouchStateFunction == NULL)
        {
            DEBUG_LOG("SetTouchState is not found");
            loadLibraryResult = false;
        }
        m_MultiTapFunction = (MultiTapFunction)GetProcAddress(m_ModuleHandle, "MultiTap");
        if(m_MultiTapFunction == NULL)
        {
            DEBUG_LOG("MultiTap is not found");
            loadLibraryResult = false;
        }
        m_MultiTouchAnimatorFunction = (MultiTouchAnimatorFunction)GetProcAddress(m_ModuleHandle, "MultiTouchAnimator");
        if(m_MultiTouchAnimatorFunction == NULL)
        {
            DEBUG_LOG("MultiTouchAnimator is not found");
            loadLibraryResult = false;
        }
        m_MultiDragPosFunction = (MultiDragPosFunction)GetProcAddress(m_ModuleHandle, "MultiDragPos");
        if(m_MultiDragPosFunction == NULL)
        {
            DEBUG_LOG("MultiDragPos is not found");
            loadLibraryResult = false;
        }
        m_MultiDragAngleFunction = (MultiDragAngleFunction)GetProcAddress(m_ModuleHandle, "MultiDragAngle");
        if(m_MultiDragAngleFunction == NULL)
        {
            DEBUG_LOG("MultiDragAngle is not found");
            loadLibraryResult = false;
        }
        m_PinchFunction = (PinchFunction)GetProcAddress(m_ModuleHandle, "Pinch");
        if(m_PinchFunction == NULL)
        {
            DEBUG_LOG("Pinch is not found");
            loadLibraryResult = false;
        }
        m_CenterTouchPinchFunction = (CenterTouchPinchFunction)GetProcAddress(m_ModuleHandle, "CenterTouchPinch");
        if(m_CenterTouchPinchFunction == NULL)
        {
            DEBUG_LOG("CenterTouchPinch is not found");
            loadLibraryResult = false;
        }
        m_MultiRotateFunction = (MultiRotateFunction)GetProcAddress(m_ModuleHandle, "MultiRotate");
        if(m_MultiRotateFunction == NULL)
        {
            DEBUG_LOG("MultiRotate is not found");
            loadLibraryResult = false;
        }
        m_CenterTouchMultiRotateFunction = (CenterTouchMultiRotateFunction)GetProcAddress(m_ModuleHandle, "CenterTouchMultiRotate");
        if(m_CenterTouchMultiRotateFunction == NULL)
        {
            DEBUG_LOG("CenterTouchMultiRotate is not found");
            loadLibraryResult = false;
        }

        return loadLibraryResult;
    }

    bool HidInputerWrapper::LoadRecordingFunctions()
    {
        bool loadLibraryResult = true;
        m_BeginHidInputRecordingFunction = (BeginHidInputRecordingFunction)GetProcAddress(m_ModuleHandle, "BeginHidInputRecording");
        if(m_BeginHidInputRecordingFunction == NULL)
        {
            DEBUG_LOG("BeginRecordingHidInput is not found");
            loadLibraryResult = false;
        }

        m_EndHidInputRecordingFunction = (EndHidInputRecordingFunction)GetProcAddress(m_ModuleHandle, "EndHidInputRecording");
        if(m_EndHidInputRecordingFunction == NULL)
        {
            DEBUG_LOG("EndRecordingHidInput is not found");
            loadLibraryResult = false;
        }

        m_ExportHidInputRecordsWithPythonScriptFunction = (ExportHidInputRecordsWithPythonScriptFunction)GetProcAddress(m_ModuleHandle, "ExportHidInputRecordsWithPythonScript");
        if(m_ExportHidInputRecordsWithPythonScriptFunction == NULL)
        {
            DEBUG_LOG("ExportRecordingHidInputWithPythonScript is not found");
            loadLibraryResult = false;
        }
        return loadLibraryResult;
    }
}



