﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include "CaptureProcessorWrapper.h"
#include "../HidInputerTest/HidInputerWrapper.h"

using namespace captureProcessor;
using namespace hidInputer;

namespace
{
    const OcrLanguage g_LanguageSet[] = { OcrLanguage::OcrLanguage_English, OcrLanguage::OcrLanguage_Japanese };
    const int g_LanguageSetCount = sizeof(g_LanguageSet) / sizeof(OcrLanguage);

    const OcrSeparateLevel g_SeparateLevelSet[] = { OcrSeparateLevel::OcrSeparateLevel_Line, OcrSeparateLevel::OcrSeparateLevel_Word };
    const int g_SeparateLevelSetCount = sizeof(g_SeparateLevelSet) / sizeof(OcrSeparateLevel);
}

TEST(CaptureProcessorSuite, ExecuteOcrTest)
{
     // Capture ライブラリのラッパークラス
    CaptureProcessorWrapper       captureProcessorWrapper;
    // ライブラリ読み込みテスト
    ASSERT_TRUE(captureProcessorWrapper.LoadCaptureLibrary());

    // 関数読み込みテスト
    ASSERT_TRUE(captureProcessorWrapper.LoadFunctiontions());

    OcrLanguage language;
    OcrSeparateLevel separate;
    OcrResultHandleType resultHandle;

    //-------------------------------------
    // 未初期化での実行
    //-------------------------------------
    int textCount = 0;
    ImageIdType imageId = { 0 };
    for (int i = 0; i < g_LanguageSetCount; i++)
    {
        for (int j = 0; j < g_SeparateLevelSetCount; j++)
        {
            language = g_LanguageSet[i];
            separate = g_SeparateLevelSet[j];
            EXPECT_EQ(CaptureResult::CaptureResult_NotInitialized,
                captureProcessorWrapper.m_ExecuteOcrFunction(&textCount, &resultHandle, imageId, separate, language));
            ImageRect rect;
            EXPECT_EQ(MatchingResult::MatchingResult_NotInitialized,
                captureProcessorWrapper.m_DetectTextForImageFunction(&rect, imageId, "test", separate, language));

            EXPECT_EQ(CaptureResult::CaptureResult_NotInitialized,
                captureProcessorWrapper.m_ReleaseOcrResultFunction(resultHandle));
        }
    }

    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();
    SerialNumberString serialNumber;
    ASSERT_GE(argc, 2);
    strncpy_s(serialNumber.value, argv[1], sizeof(serialNumber.value));

    ASSERT_EQ(captureProcessorWrapper.m_InitializeForDevkitCapture(
        serialNumber, false), CaptureResult::CaptureResult_Success);

    // 文字列取得テスト
    captureProcessorWrapper.m_GetImageFromCaptureDeviceFunction(&imageId);
    for (int i = 0; i < g_LanguageSetCount; i++)
    {
        for (int j = 0; j < g_SeparateLevelSetCount; j++)
        {
            language = g_LanguageSet[i];
            separate = g_SeparateLevelSet[j];
            // OCR テスト
            EXPECT_EQ(CaptureResult::CaptureResult_Success,
                captureProcessorWrapper.m_ExecuteOcrFunction(&textCount, &resultHandle, imageId, separate, language));

            // 文字列取得テスト
            int textSize;
            ImageRect rect;
            int copySize;
            for (int k = 0; k < textCount; k++)
            {
                EXPECT_EQ(CaptureResult::CaptureResult_Success,
                    captureProcessorWrapper.m_GetOcrResultStringSizeFunction(&textSize, resultHandle, k));

                char* string = new char[textSize];
                EXPECT_EQ(CaptureResult::CaptureResult_Success,
                    captureProcessorWrapper.m_GetOcrResultStringFunction(&rect, &copySize, string, textSize, resultHandle, k));

                delete[] string;
            }

            EXPECT_EQ(CaptureResult::CaptureResult_Unexpected,
                captureProcessorWrapper.m_GetOcrResultStringSizeFunction(&textSize, resultHandle, textCount));

            EXPECT_EQ(CaptureResult::CaptureResult_Success,
                captureProcessorWrapper.m_ReleaseOcrResultFunction(resultHandle));
        }
    }

    // ライブラリ解放テスト
    ASSERT_TRUE(captureProcessorWrapper.ReleaseCaptureLibrary());
}
