﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/base/testBase_Exit.h>
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include "testCaptureProcessor_TestDefinition.h"

/*
*   単体テスト
*   １台以上の SDEV がキャプチャボードに接続された状態で実行する必要があります。
*   また、事前に TargetManager より SDEV へ接続した状態で、InputDirector を起動しておく必要があります。
*/

INSTANTIATE_TEST_CASE_P(AllMode, CaptureModeTest,
    ::testing::Values(
        CaptureMode::CaptureMode_720p,
        CaptureMode::CaptureMode_1080p,
        CaptureMode::CaptureMode_DevKit));

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);
    const int exitCode = RUN_ALL_TESTS();

    nnt::Exit(exitCode);

    return;
}
