﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AuthoringToolsTest
{
    internal static class TestExecutionMakeDeltaNspTestData
    {
        internal static readonly Tuple<string, string, string>[] ResourceFileList = new Tuple<string, string, string>[]
        {
            new Tuple<string, string, string>("/file0.dat", "0x100", "Zero"),
            new Tuple<string, string, string>("/dir0/file1.dat", "0x100", "Zero"),
            new Tuple<string, string, string>("/BufferAddressAlignmentRo/test.file", "0x800", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/0000.file", "0x400", "Order"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/17/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/17/18/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/17/18/19/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/17/18/19/20/test.file", "0x400", "Random"),
            new Tuple<string, string, string>("/PathArgumentRo/あ.file", "0x20", "Zero"),
            new Tuple<string, string, string>("/PathArgumentRo/あ/dummy", "0x0", "Zero"),
            new Tuple<string, string, string>("/PointerArgumentRo/test.file", "0x20", "Zero"),
            new Tuple<string, string, string>("/PointerArgumentRo/test/dummy", "0x0", "Zero"),
            new Tuple<string, string, string>("/PostConditionRo/test.file", "0x20", "Random"),
            new Tuple<string, string, string>("/PostConditionRo/test/test.file", "0x20", "Zero"),
            new Tuple<string, string, string>("/PostConditionRo/test/test/dummy", "0x0", "Zero"),
            new Tuple<string, string, string>("/PreConditionRo/test.file", "0x20", "Zero"),
            new Tuple<string, string, string>("/PreConditionRo/dir/test.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/RaceConditionRo/0.file", "0x800", "Random"),
            new Tuple<string, string, string>("/RaceConditionRo/1.file", "0x800", "Zero"),
            new Tuple<string, string, string>("/ResourceOpenCountRo/Test/0000.file", "0x400", "Order"),
            new Tuple<string, string, string>("/ResourceOpenCountRo/Test/00/testEntry.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/ResourceOpenCountRo/Test/01/testEntry.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/ResourceOpenCountRo/Test/02/testEntry.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/ResourceOpenCountRo/Test/03/testEntry.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/ResourceOpenCountRo/Test/04/testEntry.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/ResourceOpenCountRo/Test/05/testEntry.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/SizeArgumentRo/0.file", "0x0", "Random"),
            new Tuple<string, string, string>("/SizeArgumentRo/32.file", "0x20", "Random"),
            new Tuple<string, string, string>("/SizeArgumentRo/4096.file", "0x1000", "Random"),
            new Tuple<string, string, string>("/SizeArgumentRo/16384.file", "0x4000", "Random"),
            new Tuple<string, string, string>("/TargetExistenceRo/test.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/TargetExistenceRo/testDir/test.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/TargetInUseRo/locked.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/TargetInUseRo/lockedDir/locked.file", "0x0", "Zero"),
            new Tuple<string, string, string>("/MediumSize/1MB_00.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_01.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_02.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_03.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_04.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_05.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_06.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_07.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_08.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_09.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_10.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_11.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_12.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_13.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_14.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_15.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_16.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_17.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_18.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize/1MB_19.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/OrderData/order_00.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_01.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_02.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_03.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_04.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_05.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_06.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_07.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_08.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_09.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_10.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_11.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_12.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_13.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_14.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_15.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_16.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_17.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_18.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_19.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/OrderData/order_20.bin", "0x100000", "Order"),
            new Tuple<string, string, string>("/DirTest/000.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/DirTest/001/001.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/DirTest/001/002/002.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/DirTest/001/012/012.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/DirTest/002/001.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/DirTest/002/002/002.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/DirTest/002/012/012.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/DirTest/003/001.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/DirTest/003/002/002.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/DirTest/003/012/012.file", "0x100000", "Random")
        };

        internal static Tuple<string, string, string>[] ResourceAddFileList = new Tuple<string, string, string>[]
        {
            new Tuple<string, string, string>("/MediumSize2/1MB_20.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_21.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_22.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_23.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_24.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_25.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_26.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_27.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_28.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_29.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_30.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_31.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_32.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_33.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_34.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_35.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_36.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_37.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_38.file", "0x100000", "Random"),
            new Tuple<string, string, string>("/MediumSize2/1MB_39.file", "0x100000", "Random")
        };

        internal static Tuple<string, string, string>[] ResourceAddDirTestFileList = new Tuple<string, string, string>[]
        {
            new Tuple<string, string, string>("/AddDirTest/001/001.file", "0x100000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/002/002.file", "0x100000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/002/002/002.file", "0x200000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/003/003.file", "0x100000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/003/003/003.file", "0x200000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/003/003/003/003.file", "0x300000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/004/004.file", "0x100000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/004/004/004.file", "0x200000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/004/004/004/004.file", "0x300000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/004/004/004/004/004.file", "0x400000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/005/005.file", "0x100000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/005/005/005.file", "0x200000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/005/005/005/005.file", "0x300000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/005/005/005/005/005.file", "0x400000", "Order"),
            new Tuple<string, string, string>("/AddDirTest/005/005/005/005/005/005.file", "0x500000", "Order")
        };

        internal static string[] ResourceDirTestFileList = new string[]
        {
            "/DirTest/001/002",
            "/DirTest/003/002",
            "/DirTest/003/012",
            "/DirTest/003",
        };

        internal static void CreateFile(string path, string size, string mode, Random random)
        {
            string dir = Path.GetDirectoryName(path);
            if (!Directory.Exists(dir))
            {
                Directory.CreateDirectory(dir);
            }

            using (var file = new FileStream(path, FileMode.Create, FileAccess.Write))
            {
                var sizeInteger = int.Parse(size.Substring(2), System.Globalization.NumberStyles.HexNumber);
                var createFileData = new byte[sizeInteger];

                switch (mode)
                {
                    case "Zero":
                        for (int i = 0; i < createFileData.Length; i++)
                        {
                            createFileData[i] = 0;
                        }
                        break;

                    case "Order":
                        for (int i = 0; i < createFileData.Length; i++)
                        {
                            createFileData[i] = (byte)i;
                        }
                        break;

                    case "Random":
                        random.NextBytes(createFileData);
                        break;
                }

                file.Write(createFileData, 0, createFileData.Length);
            }
        }
    }
}
