﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Xml.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.Authoring.AuthoringLibrary;
using Nintendo.Authoring.FileSystemMetaLibrary;
using TestUtility;

namespace AuthoringToolsTest
{
    [TestClass]
    public class XciTest
    {
        public TestContext TestContext { get; set; }

#if false // TORIAEZU: 手動テスト
        [TestMethod]
        public void TestDumpXci()
        {
            var xciPath = "D:/Develop/siglo/git_tree/sdk1/prodXci/gfxSimple_prod.xci";
            var config = new AuthoringConfiguration();
            config.KeyConfigFilePath = "D:/Develop/siglo/git_tree/sdk1/Programs/Chris/Sources/Tools/AuthoringTools/AuthoringTool/AuthoringTool.repository.keyconfig.xml";
            var keys = config.GetKeyConfiguration().GetKeyAreaEncryptionKeys();
            int maxPathLength = 10;

            using (var readerStream = new FileStream(xciPath, FileMode.Open, FileAccess.Read))
            {
                var bodyOffset = (long)XciInfo.NormalAreaStartPageAddress * XciInfo.PageSize;
                var xciBodyStream = new SubStream(readerStream, bodyOffset, readerStream.Length - bodyOffset); // カードヘッダは読み飛ばす
                var rootReader = new XciReader(xciBodyStream);
                foreach (var rootEntry in rootReader.ListFileInfo())
                {
                    var rootEntryName = rootEntry.Item1;
                    var reader = rootReader.OpenXciPartitionReader(rootEntryName);

                    foreach (var entry in reader.ListFileInfo())
                    {
                        var ncaName = entry.Item1;

                        using (var fs = new FileStream("D:/Develop/siglo/git_tree/sdk1/prodXciExtract/" + ncaName, FileMode.Create, FileAccess.ReadWrite))
                        {
                            var data = reader.ReadFile(ncaName, 0, reader.GetFileSize(ncaName));
                            fs.Write(data, 0, data.Length);
                        }
                        var ncaReader = reader.OpenNintendoContentArchiveReader(ncaName, keys);

                        foreach (var ncaInfo in ncaReader.ListFsInfo())
                        {
                            var fsIndex = ncaInfo.Item1;
                            var fsReader = ncaReader.OpenFileSystemArchiveReader(fsIndex);
                            foreach (var fsInfo in fsReader.ListFileInfo())
                            {
                                var fileName = fsInfo.Item1;
                                var fileSize = fsInfo.Item2;

                                var path = string.Format("{0}:/{1}/fs{2}/{3}", rootEntryName, ncaName, fsIndex, fileName);
                                maxPathLength = Math.Max(maxPathLength, path.Length);
                                Console.WriteLine("{0}\t({1} byte)", path.PadRight(maxPathLength + 1), fileSize);
                            }
                        }
                    }
                }
            }
        }
#endif
    }
}
