﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Xml.Serialization;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.Authoring.AuthoringLibrary;
using TestUtility;

namespace AuthoringToolsTest
{
    [TestClass]
    public class ResultTest
    {
        public TestContext TestContext { get; set; }

        private void CheckResult(ResultModel model, string errorMsg)
        {
            Assert.IsTrue(model.ErrorMessage == errorMsg);
            Assert.IsTrue(model.Code == "Failed");
            Assert.IsTrue(model.Hash == string.Empty);
            Assert.IsTrue(model.Size == 0);

            // TORIAEZU
            Assert.IsTrue(model.Date != string.Empty);
            Assert.IsTrue(model.Command != string.Empty);
            Assert.IsTrue(model.ToolVersion != string.Empty);
        }

        [TestMethod]
        public void ResultXmlTest()
        {
            // nsp, xci は ExecutionTest で確認

            // error
            {
                var msg = "Something happened.";
                var gen = new ResultXmlGenerator(msg);
                using (var xmlSt = new MemoryStream())
                {
                    gen.WriteToStream(xmlSt);
                    xmlSt.Seek(0, SeekOrigin.Begin);
                    var serializer = new XmlSerializer(typeof(ResultModel));
                    var model = (ResultModel)serializer.Deserialize(xmlSt);
                    CheckResult(model, msg);
                }
            }
        }
    }
}
