﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Xunit;
using System;

namespace Nintendo.Authoring.AuthoringEditor.Test
{
    public class TestContextFixture : IDisposable
    {
        public TestContext Context { get; } = new TestContext();

        public void Dispose()
        {
            Context.Dispose();
        }
    }

    /// <summary>
    /// TextContext の生成コストが低くない（主に SimpleInjector.Container の構築によって）ので、
    /// テストが多いクラスではこのフィクスチャを使うことで実行速度を改善できる。
    ///
    /// 一方でクラス内のテストメソッドで同一のDIコンテナインスタンスを使いまわすので、
    /// 実行順序に依存して意図しないテストの結果を引き起こす可能性があるため、使用にあたっては *十分に* 注意すること
    /// </summary>
    public class SharedTextContextBase : IClassFixture<TestContextFixture>
    {
        protected TestContext _context => _fixture.Context;
        private TestContextFixture _fixture;

        public SharedTextContextBase(TestContextFixture fixture)
        {
            _fixture = fixture;
        }
    }
}
