﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Reactive.Concurrency;
using System.Threading;
using BezelEditor.Foundation;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Nintendo.Authoring.AuthoringEditor.MainWindow.AppMenu;
using Reactive.Bindings;
using SimpleInjector;
using SimpleInjector.Diagnostics;

namespace Nintendo.Authoring.AuthoringEditor.Test
{
    public class TestContext : IDisposable
    {
        private readonly DisposableDirectory _tempDir = new DisposableDirectory();

        public Container DiContainer { get; }= new Container();
        public string TempDirPath => _tempDir.RootPath;

        public static readonly string RootPath = "../../../../../../../".ToPathString().CreateAbsolutePath(Directory.GetCurrentDirectory().ToDirectoryPathString());
        public static readonly string TestDataDirPath = Path.Combine(RootPath, "Tests/Tools/Sources/Tests/AuthoringEditorTest/TestData/").ToPathString();

        public TestContext()
        {
            CleanTestEnv();

            SetupDiContainer();
        }

        private void SetupDiContainer()
        {
            //DiContainer.Register(() => DiContainer);
            DiContainer.RegisterSingleton(() => DiContainer);
            DiContainer.RegisterSingleton<ApplicationCapability>();
            DiContainer.RegisterSingleton<App>();
            DiContainer.RegisterSingleton<AppProfile>();
//            DiContainer.RegisterSingleton(() => YamlHelper.Load(Constants.ConfigFilePath, () => new Config()));
//            DiContainer.RegisterSingleton<MainWindowVm>();

            DiContainer.Register(() => DiContainer.GetInstance<App>().Project.Meta);
            DiContainer.Register(() => DiContainer.GetInstance<App>().Project);

            /////////////////////////////////////////////////////////////////////////////
            DiContainer.GetRegistration(typeof(App)).Registration
                .SuppressDiagnosticWarning(DiagnosticType.DisposableTransientComponent, "suppress");

            DiContainer.GetRegistration(typeof(AppProfile)).Registration
                .SuppressDiagnosticWarning(DiagnosticType.DisposableTransientComponent, "suppress");

//            DiContainer.GetRegistration(typeof(MainWindowVm)).Registration
//                .SuppressDiagnosticWarning(DiagnosticType.DisposableTransientComponent, "suppress");

            DiContainer.GetRegistration(typeof(Container)).Registration
                .SuppressDiagnosticWarning(DiagnosticType.DisposableTransientComponent, "suppress");

            DiContainer.GetRegistration(typeof(ApplicationMeta)).Registration
                .SuppressDiagnosticWarning(DiagnosticType.DisposableTransientComponent, "suppress");

            DiContainer.GetRegistration(typeof(Project)).Registration
                .SuppressDiagnosticWarning(DiagnosticType.DisposableTransientComponent, "suppress");

            DiContainer.GetRegistration(typeof(AppMenuVm)).Registration
                .SuppressDiagnosticWarning(DiagnosticType.DisposableTransientComponent, "suppress");

#if DEBUG
            //DiContainer.Verify();
#endif
        }


        public void Dispose()
        {
            DiContainer.Dispose();
            _tempDir.Dispose();
        }

        private static int _isCleaned;

        public static void CleanTestEnv()
        {
            if (Interlocked.Increment(ref _isCleaned) != 1)
                return;

            ReactivePropertyScheduler.SetDefault(ImmediateScheduler.Instance);
        }

        public string CreateFile(string path)
        {
            return _tempDir.CreateFile(path);
        }

        public string CreateFolder(string path)
        {
            return _tempDir.CreateFolder(path);
        }
    }
}
