﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow;
using Nintendo.Authoring.AuthoringEditor.MainWindow.StartupPanel;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.StartupPanel
{
    public class StartupPanelVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<StartupPanelVm>())
            {
                Assert.NotNull(vm.CreateProjectCommand);
                Assert.NotNull(vm.CreateApplicationMetaCommand);
                Assert.NotNull(vm.CreateAocMetaCommand);
                Assert.NotNull(vm.CompareFilesCommand);
                Assert.NotNull(vm.OpenDocumentCommand);

                Assert.Null(vm.Parent);

                Assert.NotNull(vm.OpenProjectFromProjectCommand);
                Assert.NotNull(vm.OpenProjectFromMetaCommand);
                Assert.NotNull(vm.OpenProjectFromNspCommand);

                Assert.NotNull(vm.MruProjects);
                Assert.NotNull(vm.MruMetas);
                Assert.NotNull(vm.MruNsps);

                Assert.NotNull(vm.Culture);
            }
        }

        [Fact]
        public void CreateProjectCommand()
        {
            using (var parent = _context.DiContainer.GetInstance<MainWindowVm>())
            using (var vm = _context.DiContainer.GetInstance<StartupPanelVm>())
            {
                vm.Parent = parent;
                vm.CreateProjectCommand.Execute();
            }
        }

        [Fact]
        public void CreateApplicationMetaCommand()
        {
            using (var parent = _context.DiContainer.GetInstance<MainWindowVm>())
            using (var vm = _context.DiContainer.GetInstance<StartupPanelVm>())
            {
                vm.Parent = parent;
                vm.CreateApplicationMetaCommand.Execute();
            }
        }

        [Fact]
        public void CreateAocMetaCommand()
        {
            using (var parent = _context.DiContainer.GetInstance<MainWindowVm>())
            using (var vm = _context.DiContainer.GetInstance<StartupPanelVm>())
            {
                vm.Parent = parent;
                vm.CreateAocMetaCommand.Execute();
            }
        }

        [Fact]
        public void CompareFilesCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<StartupPanelVm>())
            {
                vm.CompareFilesCommand.Execute();
            }
        }

        [Fact]
        public void OpenDocumentCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<StartupPanelVm>())
            {
                vm.OpenDocumentCommand.Execute();
            }
        }

        [Fact]
        public void OpenProjectFromProjectCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<StartupPanelVm>())
            {
                vm.OpenProjectFromProjectCommand.Execute(new MruItemVm(new MruItem()));
            }
        }

        [Fact]
        public void OpenProjectFromMetaCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<StartupPanelVm>())
            {
                vm.OpenProjectFromMetaCommand.Execute(new MruItemVm(new MruItem()));
            }
        }

        [Fact]
        public void OpenProjectFromNspCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<StartupPanelVm>())
            {
                vm.OpenProjectFromNspCommand.Execute(new MruItemVm(new MruItem()));
            }
        }
    }
}
