﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel
{
    public class ProjectEditPanelVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<ProjectEditPanelVm>())
            {
                Assert.NotNull(vm.SearchWord);
                Assert.NotNull(vm.DelaySearchWord);
                Assert.NotNull(vm.SearchHitPageCount);

                Assert.NotNull(vm.AllPages);
                Assert.NotNull(vm.AllSelectedPage);

                Assert.NotNull(vm.OverviewPages);
                Assert.NotNull(vm.BasicPages);
                Assert.NotNull(vm.GeneralPages);

                Assert.NotNull(vm.OverviewSelectedPage);
                Assert.NotNull(vm.BasicSelectedPage);
                Assert.NotNull(vm.GeneralSelectedPage);

                Assert.Null(vm.HasErrorsOverviewPages);
                Assert.NotNull(vm.HasErrorsBasicPages);
                Assert.NotNull(vm.HasErrorsGeneralPages);
            }
        }

        [Theory]
        [InlineData(AppModeType.AocMeta)]
        [InlineData(AppModeType.ApplicationNsp)]
        public void SetupPages(AppModeType appMode)
        {
            _context.DiContainer.GetInstance<AppProfile>().AppMode = appMode;
            using (_context.DiContainer.GetInstance<ProjectEditPanelVm>())
            {
            }
        }

        [Theory]
        [InlineData(0.0)]
        [InlineData(123.456)]
        public void UpdatePageMargin(double pageHeight)
        {
            using (var vm = _context.DiContainer.GetInstance<ProjectEditPanelVm>())
            {
                vm.UpdatePageMargin(pageHeight);
            }
        }
    }
}
