﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.ObjectModel;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Reactive.Bindings;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Params
{
    public class ApplicationIdParamVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = new ApplicationIdParamVm(null, null, null,
                new ObservableCollection<NintendoApplicationId>(),
                1,
                new ReactiveProperty<bool>()))
            {
                Assert.NotNull(vm.ApplicationIds);
                Assert.NotNull(vm.AddCommand);
                Assert.NotNull(vm.RemoveCommand);
            }
        }

        [Fact]
        public void AddCommand()
        {
            using (var vm = new ApplicationIdParamVm(null, null, null,
                new ObservableCollection<NintendoApplicationId>(),
                1,
                new ReactiveProperty<bool>()))
            {
                vm.AddCommand.Execute();
            }
        }

        [Fact]
        public void RemoveCommand()
        {
            using (var vm = new ApplicationIdParamVm(null, null, null,
                new ObservableCollection<NintendoApplicationId>(),
                1,
                new ReactiveProperty<bool>()))
            {
                vm.RemoveCommand.Execute(new ApplicationIdVm(new NintendoApplicationId(), vm.RemoveCommand, new ReactiveProperty<bool>()));
            }
        }
    }
}
