﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Pages
{
    public class BcatPageVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<BcatPageVm>())
            {
                Assert.NotNull(vm.Params);
            }
        }

        [Fact]
        public void ValidationTest()
        {
            if (_context.DiContainer.GetInstance<ApplicationCapability>().IsSupportBcat == false)
                return;

            using (var vm = _context.DiContainer.GetInstance<BcatPageVm>())
            using (var meta = _context.DiContainer.GetInstance<Project>().Meta)
            {
                Assert.False(vm.HasErrors.Value);

                meta.Application.IsUseBcat = true;
                Assert.True(vm.HasErrors.Value);

                meta.Application.BcatDeliveryCacheStorageSize = 1024 * 1024 * 5;
                meta.Application.BcatPassphrase = "2be7b01684f98f8a668d9f474c6583a44c418bb72be7b01684f98f8a668d9f40";
                Assert.False(vm.HasErrors.Value);

                meta.Application.BcatDeliveryCacheStorageSize = 1024 * 1024 * 5 + 1;
                Assert.True(vm.HasErrors.Value);

                meta.Application.IsUseBcat = false;
                Assert.False(vm.HasErrors.Value);
            }
        }
    }
}
