﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test
{
    public class CommandLineParamsTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            var p = new CommandLineParams();

            Assert.Null(p.ProjectPath);
            Assert.Null(p.MetaPath);
            Assert.Null(p.NintendoMetaPath);
            Assert.Null(p.NspPath);
            Assert.Null(p.NspdPath);
            Assert.Null(p.Mode);
            Assert.Null(p.InputFilePath);
        }

        [Fact]
        public void Basic()
        {
            // ReSharper disable once HeapView.ObjectAllocation.Evident
            // ReSharper disable once ObjectCreationAsStatement
            new CommandLineParams
            {
                ProjectPath = "A",
                MetaPath = "A",
                NintendoMetaPath = "A",
                NspPath = "A",
                NspdPath = "A",
                Mode = "A",
                InputFilePath = "A",
            };
        }

        [Fact]
        public void StaticMember()
        {
            Assert.NotNull(CommandLineParams.HelpProjectPath);
            Assert.NotNull(CommandLineParams.HelpMetaPath);
            Assert.NotNull(CommandLineParams.HelpNspPath);
            Assert.NotNull(CommandLineParams.HelpNspdPath);
            Assert.NotNull(CommandLineParams.HelpMode);
            Assert.NotNull(CommandLineParams.HelpInputFilePath);
        }
    }
}
