﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Xml.Serialization;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Foundation.Test
{
    public class StringWriterUtf8Test : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void Ctor()
        {
            using (new StringWriterUtf8())
            {
            }
        }

        public class Data
        {
            public int A { get; set; }
            public int B { get; set; }
        }

        [Fact]
        public void Basic()
        {
            using (var w = new StringWriterUtf8())
            {
                var data = new Data
                {
                    A = 123,
                    B = 465
                };

                new XmlSerializer(typeof(Data)).Serialize(w, data);

                var s = w.ToString();
                Assert.NotEqual(string.Empty, s);
            }
        }
    }
}
