﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Foundation.Test
{
    public class NumberHelperTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Theory]
        [InlineData("0Byte", 0)]
        [InlineData("1Byte", 1)]
        [InlineData("1.023KBytes 0.999KiB (1023Bytes)", 1023)]
        [InlineData("1.024KBytes 1KiB (1024Bytes)", 1024)]
        [InlineData("1.025KBytes 1.001KiB (1025Bytes)", 1025)]
        [InlineData("1.049MBytes 1MiB (1048575Bytes)", 1024 * 1024 - 1)]
        [InlineData("1.049MBytes 1MiB (1048576Bytes)", 1024 * 1024)]
        [InlineData("33.554MBytes 32MiB (33554432Bytes)", 1024 * 1024 * 32)]
        [InlineData("33.554MBytes 32MiB (33554431Bytes)", 1024 * 1024 * 32 - 1)]
        [InlineData("1.048GBytes 0.976GiB (1047527424Bytes)", 1024 * 1024 * 999)]
        [InlineData("1.074GBytes 1GiB (1073741824Bytes)", 1024 * 1024 * 1024)]
        public void ToReadableSizeString(string expected, ulong value)
        {
            Assert.Equal(expected, value.ToReadableSizeString());
        }

        [Theory]
        [InlineData("0Byte", -1L)]
        [InlineData("1Byte", 1L)]
        [InlineData("1.023KBytes 0.999KiB (1023Bytes)", 1023)]
        [InlineData("1.024KBytes 1KiB (1024Bytes)", 1024)]
        [InlineData("1.025KBytes 1.001KiB (1025Bytes)", 1025)]
        [InlineData("1.049MBytes 1MiB (1048575Bytes)", 1024 * 1024 - 1)]
        [InlineData("1.049MBytes 1MiB (1048576Bytes)", 1024 * 1024)]
        [InlineData("33.554MBytes 32MiB (33554432Bytes)", 1024 * 1024 * 32)]
        [InlineData("33.554MBytes 32MiB (33554431Bytes)", 1024 * 1024 * 32 - 1)]
        [InlineData("1.048GBytes 0.976GiB (1047527424Bytes)", 1024 * 1024 * 999)]
        [InlineData("1.074GBytes 1GiB (1073741824Bytes)", 1024 * 1024 * 1024)]
        public void ToReadableSizeStringAsLong(string expected, long value)
        {
            Assert.Equal(expected, value.ToReadableSizeString());
        }
    }
}
