﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Foundation.Test
{
    public class MathHelperTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Theory]
        [InlineData(false, 0)]
        [InlineData(true,  2)]
        [InlineData(false, 3)]
        [InlineData(true,  4)]
        [InlineData(false, 255)]
        [InlineData(true,  256)]
        [InlineData(false, 257)]
        [InlineData(false, 4095)]
        [InlineData(true,  4096)]
        [InlineData(false, 4097)]
        public void IsPowerOfTwoInt(bool expected, int value)
        {
            Assert.Equal(expected, MathHelper.IsPowerOfTwo(value));
        }

        [Theory]
        [InlineData(false, (ulong)0)]
        [InlineData(true,  (ulong)2)]
        [InlineData(false, (ulong)3)]
        [InlineData(true,  (ulong)4)]
        [InlineData(false, (ulong)255)]
        [InlineData(true,  (ulong)256)]
        [InlineData(false, (ulong)257)]
        [InlineData(false, (ulong)4095)]
        [InlineData(true,  (ulong)4096)]
        [InlineData(false, (ulong)4097)]
        public void IsPowerOfTwoUlong(bool expected, ulong value)
        {
            Assert.Equal(expected, MathHelper.IsPowerOfTwo(value));
        }
    }
}
