﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.Authoring.AuthoringEditor.Core.Test
{
    public static class TypeExtensions
    {
        public static TValue GetPropertyValue<TValue>(this object target, string propertyName)
        {
            return (TValue)target.GetType().GetProperty(propertyName)?.GetValue(target);
        }

        public static void SetPropertyValue<TValue>(this object target, string propertyName, TValue value)
        {
            target.GetType().GetProperty(propertyName)?.SetValue(target, value);
        }
    }
}
