﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Threading.Tasks;
using Nintendo.Authoring.AuthoringEditor.Core.Test.Fixtures;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Core.Test
{
    public class NspPublishableCheckerTest : IDisposable, IClassFixture<BuildTestAppNspFixture>
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        private readonly BuildTestAppNspFixture _fixture;

        public NspPublishableCheckerTest(BuildTestAppNspFixture fixture)
        {
            _fixture = fixture.Initialize();
        }

        [Fact]
        public void DefaultCtor()
        {
            var checker = new NspPublishableChecker();
        }

        [Fact]
        public async Task Check()
        {
            var checker = new NspPublishableChecker();
            var r = await checker.CheckUnpublishableErrorAsync(_fixture.NspFilePath).ConfigureAwait(false);
            Assert.NotNull(r);
            Assert.NotEmpty(r.Content.Errors);
        }
    }
}
