﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Core.Test
{
    public class ConstantsTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void ConfigFilePath()
        {
            Assert.False(string.IsNullOrEmpty(Constants.ConfigFilePath));
        }

        [Fact]
        public void ConfigDirPath()
        {
            Assert.False(string.IsNullOrEmpty(Constants.ConfigDirPath));
        }

        [Fact]
        public void AllRatingOrganizations()
        {
            Assert.NotNull(Constants.AllRatingOrganizations);
            Assert.NotEmpty(Constants.AllRatingOrganizations);
        }

        [Fact]
        public void CheckPEGIBBFCRatingCategoriesCount()
        {
            Assert.True(Constants.AllRatingData.ContainsKey("PEGIBBFC"));
            Assert.Equal(15, Constants.AllRatingData["PEGIBBFC"].Categories.Length);
        }
    }
}
