﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _3dToolsTestUtility
{
    public class ScopedFileCreator : IDisposable
    {
        public ScopedFileCreator()
        {
            this.FilePath = IoUtility.GetTempFilePath(string.Empty);
            System.IO.File.Create(this.FilePath).Close();
        }

        public ScopedFileCreator(string baseName)
        {
            this.FilePath = IoUtility.GetTempFilePath(baseName);
            System.IO.File.Create(this.FilePath).Close();
        }

        public void Dispose()
        {
            System.IO.File.Delete(this.FilePath);
        }

        public string FilePath { get; private set; }
    }
}
