﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _3dToolsTestUtility
{
    public class ScopedDirectoryCreator : IDisposable
    {
        public ScopedDirectoryCreator()
        {
            this.DirectoryPath = IoUtility.GetTempFolderPath();
            System.IO.Directory.CreateDirectory(this.DirectoryPath);
        }

        public ScopedDirectoryCreator(string directoryPath)
        {
            this.DirectoryPath = directoryPath;
            System.IO.Directory.CreateDirectory(this.DirectoryPath);
        }

        public void Dispose()
        {
            System.IO.Directory.Delete(this.DirectoryPath, true);
        }

        public string DirectoryPath { get; private set; }
    }
}
