﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace _3dToolsTestUtility
{
    public static class CompareUtility
    {
        /// <summary>
        /// Xml に変換して比較
        /// </summary>
        public static bool AreEqualAsXml<T>(T lhs, T rhs)
        {
            return ToXml(lhs) == ToXml(rhs);
        }

        /// <summary>
        /// Xml の文字列に変換
        /// </summary>
        public static string ToXml<T>(T target)
        {
            if (target == null)
            {
                return null;
            }
            using (var stringWriter = new StringWriter())
            {
                var serializer = new XmlSerializer(typeof(T));
                var writerSettings = new XmlWriterSettings()
                {
                    Encoding = new UnicodeEncoding(false, false),
                    Indent = false,
                    CheckCharacters = false,
                    OmitXmlDeclaration = true,
                };
                using (var writer = XmlWriter.Create(stringWriter, writerSettings))
                {
                    serializer.Serialize(writer, target);
                }
                return stringWriter.ToString();
            }
        }
    }
}
