﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using _3dToolsTestUtility;

namespace _3dIntermediateFileLibraryTest
{
    [TestClass]
    public class QuantizationAnalysisTest
    {
        [TestMethod]
        public void AlignPositionQuantizationWithDccToolShapeUnitTest()
        {
            IfModelQuantizationAnalysisOptimizer optimizer = new IfModelQuantizationAnalysisOptimizer();
            var model = ModelDataCreationUtility.CreateEmptyModel();
            ModelDataCreationUtility.AddBone(model, "boneRoot", string.Empty, -1, -1, new float[] { 0.0f, 0.0f, 0.0f }, new float[] { 1.0f, 1.0f, 1.0f });
            model.AddStream("1.1 1.2 1.3    1.1 1.2 1.3    1.1 1.2 1.3", stream_typeType.@float, 9, 3);
            ModelDataCreationUtility.AddStream(model, "0 1 2", stream_typeType.@int, 3, 3);
            model.AddVertexAttribute(new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.float_16_16_16_16
                    },
                });
            model.AddVertexAttribute(new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.float_16_16_16_16
                    },
                });
            model.AddVertexAttribute(new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.float_32_32_32
                    },
                });
            model.AddVertexAttribute(new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.float_16_16_16_16
                    },
                });
            ModelDataCreationUtility.AddShape(model, "shapeA__matA", "matA", "boneRoot", 0, 1).shape_info.original_bone_name = "shapeA,shapeAA";
            ModelDataCreationUtility.AddShape(model, "shapeB__matB", "matB", "boneRoot", 1, 1).shape_info.original_bone_name = "shapeB";
            ModelDataCreationUtility.AddShape(model, "shapeA__matC", "matC", "boneRoot", 2, 1).shape_info.original_bone_name = "shapeA";
            ModelDataCreationUtility.AddShape(model, "shapeA__mat__D", "mat__D", "boneRoot", 3, 1).shape_info.original_bone_name = "shapeA";

            model.AddVertexAttribute(new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.float_16_16_16_16
                    },
                });
            ModelDataCreationUtility.AddShape(model, "shapeA__", "matE", "boneRoot", 4, 1).shape_info.original_bone_name = "";
            ModelDataCreationUtility.AddShape(model, "shapeA__matFFF", "matF", "boneRoot", 4, 1).shape_info.original_bone_name = "";
            ModelDataCreationUtility.AddShape(model, "shapeA_matG", "matG", "boneRoot", 4, 1).shape_info.original_bone_name = "";

            // マテリアル圧縮されたケースのテスト
            model.AddVertexAttribute(new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.float_16_16_16_16
                    },
                });
            model.AddVertexAttribute(new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.float_32_32_32
                    },
                });
            model.AddVertexAttribute(new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.none
                    },
                });
            ModelDataCreationUtility.AddShape(model, "shapeC__matH", "matI", "boneRoot", 5, 1).shape_info.original_bone_name = "shapeC";
            ModelDataCreationUtility.AddShape(model, "shapeC__matI", "matI", "boneRoot", 6, 1).shape_info.original_bone_name = "shapeC";
            ModelDataCreationUtility.AddShape(model, "shapeC__matJ", "matI", "boneRoot", 7, 1).shape_info.original_bone_name = "shapeC";

            optimizer.AlignPositionQuantizationWithDccToolShapeUnit(model);

            // 同じシェイプが一番高い精度の量子化精度にアラインされることをテスト
            Assert.AreEqual(vtx_attrib_quantize_typeType.float_32_32_32, model.vertex_array.vertex[0].vtx_attrib_array.vtx_attrib[0].quantize_type);
            Assert.AreEqual(vtx_attrib_quantize_typeType.float_16_16_16_16, model.vertex_array.vertex[1].vtx_attrib_array.vtx_attrib[0].quantize_type);
            Assert.AreEqual(vtx_attrib_quantize_typeType.float_32_32_32, model.vertex_array.vertex[2].vtx_attrib_array.vtx_attrib[0].quantize_type);
            Assert.AreEqual(vtx_attrib_quantize_typeType.float_32_32_32, model.vertex_array.vertex[3].vtx_attrib_array.vtx_attrib[0].quantize_type);

            Assert.AreEqual(vtx_attrib_quantize_typeType.none, model.vertex_array.vertex[5].vtx_attrib_array.vtx_attrib[0].quantize_type);
            Assert.AreEqual(vtx_attrib_quantize_typeType.none, model.vertex_array.vertex[6].vtx_attrib_array.vtx_attrib[0].quantize_type);
            Assert.AreEqual(vtx_attrib_quantize_typeType.none, model.vertex_array.vertex[7].vtx_attrib_array.vtx_attrib[0].quantize_type);

            // シェイプ名の書式が DCC ツールからエクスポートされた書式でないのでアラインされない
            Assert.AreEqual(vtx_attrib_quantize_typeType.float_16_16_16_16, model.vertex_array.vertex[4].vtx_attrib_array.vtx_attrib[0].quantize_type);

            // スキニング数違いのケースのテスト
            {
                model.AddVertexAttribute(new VertexAttr[]
                    {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.float_16_16_16_16
                    },
                    });
                model.AddVertexAttribute(new VertexAttr[]
                    {
                    new VertexAttr()
                    {
                        Name = "_p0", Hint = "position0", StreamIndex = 0, Type = vtx_attrib_typeType.float3,
                        QuantizeType = vtx_attrib_quantize_typeType.float_16_16_16_16
                    },
                    });
                var shape0 = ModelDataCreationUtility.AddShape(model, "shapeD__matJ", "matJ", "boneRoot", 8, 1);
                var shape1 = ModelDataCreationUtility.AddShape(model, "shapeD__matK", "matK", "boneRoot", 9, 1);

                // スキニング方式が同じシェイプ同士の場合は位置座標の量子化精度は大きいものにアラインされることをテスト
                {
                    // リジッドボディ同士
                    shape0.shape_info.vertex_skinning_count = 0;
                    shape1.shape_info.vertex_skinning_count = 0;

                    optimizer.AlignPositionQuantizationWithDccToolShapeUnit(model);

                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_16_16_16_16, model.vertex_array.vertex[8].vtx_attrib_array.vtx_attrib[0].quantize_type);
                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_16_16_16_16, model.vertex_array.vertex[9].vtx_attrib_array.vtx_attrib[0].quantize_type);
                }

                {
                    // リジッドスキニング同士
                    shape0.shape_info.vertex_skinning_count = 1;
                    shape1.shape_info.vertex_skinning_count = 1;

                    optimizer.AlignPositionQuantizationWithDccToolShapeUnit(model);

                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_16_16_16_16, model.vertex_array.vertex[8].vtx_attrib_array.vtx_attrib[0].quantize_type);
                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_16_16_16_16, model.vertex_array.vertex[9].vtx_attrib_array.vtx_attrib[0].quantize_type);
                }

                {
                    // スムーススキニング同士
                    shape0.shape_info.vertex_skinning_count = 2;
                    shape1.shape_info.vertex_skinning_count = 2;

                    optimizer.AlignPositionQuantizationWithDccToolShapeUnit(model);

                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_16_16_16_16, model.vertex_array.vertex[8].vtx_attrib_array.vtx_attrib[0].quantize_type);
                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_16_16_16_16, model.vertex_array.vertex[9].vtx_attrib_array.vtx_attrib[0].quantize_type);
                }

                // スキニング方式が異なるシェイプ同士の場合は位置座標の量子化精度が float_32_32_32 になることをテスト
                {
                    // リジッドボディとリジッドスキニング
                    shape0.shape_info.vertex_skinning_count = 0;
                    shape1.shape_info.vertex_skinning_count = 1;

                    optimizer.AlignPositionQuantizationWithDccToolShapeUnit(model);

                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_32_32_32, model.vertex_array.vertex[8].vtx_attrib_array.vtx_attrib[0].quantize_type);
                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_32_32_32, model.vertex_array.vertex[9].vtx_attrib_array.vtx_attrib[0].quantize_type);
                }
                {
                    // リジッドスキニングとスムーススキニング
                    shape0.shape_info.vertex_skinning_count = 1;
                    shape1.shape_info.vertex_skinning_count = 2;

                    optimizer.AlignPositionQuantizationWithDccToolShapeUnit(model);

                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_32_32_32, model.vertex_array.vertex[8].vtx_attrib_array.vtx_attrib[0].quantize_type);
                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_32_32_32, model.vertex_array.vertex[9].vtx_attrib_array.vtx_attrib[0].quantize_type);
                }
                {
                    // リジッドボディとスキニング
                    shape0.shape_info.vertex_skinning_count = 0;
                    shape1.shape_info.vertex_skinning_count = 2;

                    optimizer.AlignPositionQuantizationWithDccToolShapeUnit(model);

                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_32_32_32, model.vertex_array.vertex[8].vtx_attrib_array.vtx_attrib[0].quantize_type);
                    Assert.AreEqual(vtx_attrib_quantize_typeType.float_32_32_32, model.vertex_array.vertex[9].vtx_attrib_array.vtx_attrib[0].quantize_type);
                }
            }
        }
    }
}
