﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using System.Collections.Generic;

namespace _3dIntermediateFileLibraryTest
{
    [TestClass]
    public class MergeSkeletalAnimTest
    {
        [TestMethod]
        public void SkeletalAnimMergerTest()
        {
            skeletal_animType skeletalAnimMerge = new skeletal_animType()
            {
                skeletal_anim_info = new skeletal_anim_infoType()
                {
                },
                bone_anim_array = new bone_anim_arrayType()
                {
                    Items = new bone_animType[]
                    {
                        new bone_animType()
                        {
                            bone_name = "boneA",
                            bone_anim_target = new bone_anim_targetType[]
                            {
                                new bone_anim_targetType()
                                {
                                    target = bone_anim_target_targetType.translate_x,
                                }
                            },
                            user_data_array = new user_data_arrayType()
                            {
                                Items = new user_dataType[]
                                {
                                    new user_dataType()
                                    {
                                        name = "UserDataA",
                                        Item = "B"
                                    },
                                    new user_dataType()
                                    {
                                        name = "UserDataD"
                                    }
                                }
                            }
                        }
                    }
                }
            };

            // bone_anim の user_data が正しくマージされていることをテスト
            {
                skeletal_animType skeletalAnim = new skeletal_animType()
                {
                    skeletal_anim_info = new skeletal_anim_infoType()
                    {
                    },
                    bone_anim_array = new bone_anim_arrayType()
                    {
                        Items = new bone_animType[]
                        {
                            new bone_animType()
                            {
                                bone_name = "boneA",
                                bone_anim_target = new bone_anim_targetType[]
                                {
                                    new bone_anim_targetType()
                                    {
                                        target = bone_anim_target_targetType.translate_x,
                                    }
                                },
                                user_data_array = new user_data_arrayType()
                                {
                                    Items = new user_dataType[]
                                    {
                                        new user_dataType()
                                        {
                                            name = "UserDataA",
                                            Item = "A"
                                        },
                                        new user_dataType()
                                        {
                                            name = "UserDataB"
                                        },
                                        new user_dataType()
                                        {
                                            name = "UserDataC"
                                        }
                                    }
                                }
                            }
                        }
                    }
                };

                IfSkeletalAnimMerger.Merge(skeletalAnim, new List<G3dStream>(), skeletalAnimMerge, new List<G3dStream>());

                bone_animType boneAnim = skeletalAnim.bone_anim_array.bone_anim[0];
                Assert.AreEqual(4, boneAnim.user_data_array.Items.Length);
                Assert.AreEqual("UserDataA", boneAnim.user_data_array.user_data[0].name);
                Assert.AreEqual("UserDataB", boneAnim.user_data_array.user_data[1].name);
                Assert.AreEqual("UserDataC", boneAnim.user_data_array.user_data[2].name);
                Assert.AreEqual("UserDataD", boneAnim.user_data_array.user_data[3].name);
                Assert.AreEqual("A", boneAnim.user_data_array.user_data[0].Item as string);
            }

            // 片方の user_data が null の場合
            {
                skeletal_animType skeletalAnim = new skeletal_animType()
                {
                    skeletal_anim_info = new skeletal_anim_infoType()
                    {
                    },
                    bone_anim_array = new bone_anim_arrayType()
                    {
                        Items = new bone_animType[]
                        {
                            new bone_animType()
                            {
                                bone_name = "boneA",
                                bone_anim_target = new bone_anim_targetType[]
                                {
                                    new bone_anim_targetType()
                                    {
                                        target = bone_anim_target_targetType.translate_x,
                                    }
                                },
                            }
                        }
                    }
                };

                IfSkeletalAnimMerger.Merge(skeletalAnim, new List<G3dStream>(), skeletalAnimMerge, new List<G3dStream>());

                bone_animType boneAnim = skeletalAnim.bone_anim_array.bone_anim[0];
                Assert.AreEqual(2, boneAnim.user_data_array.Items.Length);
                Assert.AreEqual("UserDataA", boneAnim.user_data_array.user_data[0].name);
                Assert.AreEqual("UserDataD", boneAnim.user_data_array.user_data[1].name);
            }
        }
    }
}
